<?php

namespace Database\Seeders;

use App\Models\Truck;
use Illuminate\Database\Seeder;

class TruckSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Buat 10 truck dengan factory
        Truck::factory(10)->create();
        
        // Buat beberapa truck dengan data spesifik
        Truck::create([
            'plate_number' => 'B1234KLM',
            'brand' => 'Hino',
            'model' => 'Ranger',
            'year' => 2022,
            'capacity' => '20 ton',
            'fuel_type' => 'Solar',
            'status' => 'active',
            'purchase_date' => '2022-01-15',
            'last_service_date' => '2023-05-20',
            'next_service_date' => '2023-11-20',
            'stnk_number' => '1234567890',
            'stnk_expire_date' => '2025-01-15',
            'kir_number' => 'KIR-2022-1234',
            'kir_expire_date' => '2024-01-15',
            'notes' => 'Truck utama untuk pengiriman jarak jauh',
        ]);
        
        Truck::create([
            'plate_number' => 'B5678NOP',
            'brand' => 'Mitsubishi',
            'model' => 'Fuso',
            'year' => 2021,
            'capacity' => '15 ton',
            'fuel_type' => 'Biodiesel',
            'status' => 'active',
            'purchase_date' => '2021-03-10',
            'last_service_date' => '2023-04-15',
            'next_service_date' => '2023-10-15',
            'stnk_number' => '0987654321',
            'stnk_expire_date' => '2024-03-10',
            'kir_number' => 'KIR-2021-5678',
            'kir_expire_date' => '2023-07-10', // Sudah expired untuk contoh
            'notes' => 'Truck untuk pengiriman dalam kota',
        ]);
        
        // Tambahkan truck dengan STNK yang akan segera expired
        Truck::create([
            'plate_number' => 'B9012QRS',
            'brand' => 'Isuzu',
            'model' => 'Giga',
            'year' => 2020,
            'capacity' => '12 ton',
            'fuel_type' => 'Solar',
            'status' => 'active',
            'purchase_date' => '2020-06-05',
            'last_service_date' => '2023-03-10',
            'next_service_date' => '2023-09-10',
            'stnk_number' => '5678901234',
            'stnk_expire_date' => now()->addDays(15), // Akan expired dalam 15 hari
            'kir_number' => 'KIR-2020-9012',
            'kir_expire_date' => now()->addDays(25), // Akan expired dalam 25 hari
            'notes' => 'Truck untuk pengiriman regional',
        ]);
    }
}
