<?php
$baseUrl = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://" . $_SERVER['HTTP_HOST'] . dirname($_SERVER['PHP_SELF']);

// Fungsi untuk menjalankan perintah dan menangkap output
function runCommand($command) {
    $output = null;
    $resultCode = null;
    exec($command . ' 2>&1', $output, $resultCode);
    return [
        'output' => $output,
        'result_code' => $resultCode
    ];
}

// Fungsi untuk memeriksa persyaratan
function checkRequirements() {
    $requirements = [
        'php_version' => version_compare(PHP_VERSION, '8.0.0', '>='),
        'composer' => file_exists(getcwd() . '/composer.json'),
        'env_file' => file_exists(getcwd() . '/.env.example'),
        'storage_writable' => is_writable(getcwd() . '/storage'),
        'bootstrap_cache_writable' => is_writable(getcwd() . '/bootstrap/cache'),
    ];
    
    return $requirements;
}

// Fungsi untuk mengatur file .env
function setupEnvFile() {
    $envExample = getcwd() . '/.env.example';
    $envFile = getcwd() . '/.env';
    
    if (!file_exists($envFile) && file_exists($envExample)) {
        copy($envExample, $envFile);
        
        // Ubah nama aplikasi
        $envContent = file_get_contents($envFile);
        $envContent = preg_replace('/APP_NAME=.*/', 'APP_NAME="Omika Bangun Mandiri"', $envContent);
        file_put_contents($envFile, $envContent);
        
        return true;
    }
    
    return false;
}

// Proses instalasi
$step = isset($_GET['step']) ? (int)$_GET['step'] : 1;
$message = '';
$error = '';
$requirements = checkRequirements();

// Proses form
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    switch ($step) {
        case 1: // Database setup
            if (isset($_POST['db_host'], $_POST['db_name'], $_POST['db_user'], $_POST['db_pass'])) {
                $envFile = getcwd() . '/.env';
                if (!file_exists($envFile)) {
                    setupEnvFile();
                }
                
                $envContent = file_get_contents($envFile);
                $envContent = preg_replace('/DB_HOST=.*/', 'DB_HOST=' . $_POST['db_host'], $envContent);
                $envContent = preg_replace('/DB_DATABASE=.*/', 'DB_DATABASE=' . $_POST['db_name'], $envContent);
                $envContent = preg_replace('/DB_USERNAME=.*/', 'DB_USERNAME=' . $_POST['db_user'], $envContent);
                $envContent = preg_replace('/DB_PASSWORD=.*/', 'DB_PASSWORD=' . $_POST['db_pass'], $envContent);
                file_put_contents($envFile, $envContent);
                
                $message = 'Konfigurasi database berhasil disimpan!';
                header('Location: ' . $baseUrl . '/install.php?step=2');
                exit;
            }
            break;
            
        case 2: // Install dependencies
            $result = runCommand('composer install --no-dev --optimize-autoloader');
            if ($result['result_code'] === 0) {
                $message = 'Dependensi berhasil diinstal!';
                header('Location: ' . $baseUrl . '/install.php?step=3');
                exit;
            } else {
                $error = 'Gagal menginstal dependensi: ' . implode("\n", $result['output']);
            }
            break;
            
        case 3: // Generate key and run migrations
            $keyResult = runCommand('php artisan key:generate');
            if ($keyResult['result_code'] === 0) {
                $migrateResult = runCommand('php artisan migrate' . (isset($_POST['with_seed']) ? ' --seed' : ''));
                if ($migrateResult['result_code'] === 0) {
                    $message = 'Migrasi database berhasil!';
                    header('Location: ' . $baseUrl . '/install.php?step=4');
                    exit;
                } else {
                    $error = 'Gagal menjalankan migrasi: ' . implode("\n", $migrateResult['output']);
                }
            } else {
                $error = 'Gagal generate key aplikasi: ' . implode("\n", $keyResult['output']);
            }
            break;
            
        case 4: // Optimize application
            $commands = [
                'php artisan optimize:clear',
                'php artisan config:cache',
                'php artisan route:cache',
                'php artisan view:cache',
                'php artisan storage:link'
            ];
            
            $allSuccess = true;
            foreach ($commands as $command) {
                $result = runCommand($command);
                if ($result['result_code'] !== 0) {
                    $error = 'Gagal mengoptimalkan aplikasi: ' . implode("\n", $result['output']);
                    $allSuccess = false;
                    break;
                }
            }
            
            if ($allSuccess) {
                // Buat file untuk menandai instalasi selesai
                file_put_contents(getcwd() . '/storage/installed', date('Y-m-d H:i:s'));
                $message = 'Instalasi selesai!';
                header('Location: ' . $baseUrl . '/install.php?step=5');
                exit;
            }
            break;
    }
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Installer Omika Bangun Mandiri</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background-color: #f8f9fa;
            padding-top: 40px;
        }
        .installer-container {
            max-width: 800px;
            margin: 0 auto;
            background: white;
            border-radius: 10px;
            box-shadow: 0 0 20px rgba(0,0,0,0.1);
            padding: 30px;
        }
        .step-indicator {
            display: flex;
            margin-bottom: 30px;
        }
        .step {
            flex: 1;
            text-align: center;
            padding: 10px;
            position: relative;
        }
        .step:not(:last-child):after {
            content: '';
            position: absolute;
            top: 50%;
            right: -10%;
            width: 20%;
            height: 2px;
            background-color: #dee2e6;
        }
        .step.active {
            font-weight: bold;
            color: #0d6efd;
        }
        .step.completed:not(:last-child):after {
            background-color: #0d6efd;
        }
        .step-number {
            display: inline-block;
            width: 30px;
            height: 30px;
            line-height: 30px;
            border-radius: 50%;
            background-color: #dee2e6;
            color: #6c757d;
            margin-right: 5px;
        }
        .step.active .step-number, .step.completed .step-number {
            background-color: #0d6efd;
            color: white;
        }
        .logo {
            text-align: center;
            margin-bottom: 20px;
        }
        .logo h1 {
            color: #333;
            font-weight: bold;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="installer-container">
            <div class="logo">
                <h1>Omika Bangun Mandiri</h1>
                <p class="lead">Installer Sistem</p>
            </div>
            
            <div class="step-indicator">
                <div class="step <?php echo ($step >= 1) ? 'active' : ''; ?> <?php echo ($step > 1) ? 'completed' : ''; ?>">
                    <span class="step-number">1</span> Database
                </div>
                <div class="step <?php echo ($step >= 2) ? 'active' : ''; ?> <?php echo ($step > 2) ? 'completed' : ''; ?>">
                    <span class="step-number">2</span> Dependensi
                </div>
                <div class="step <?php echo ($step >= 3) ? 'active' : ''; ?> <?php echo ($step > 3) ? 'completed' : ''; ?>">
                    <span class="step-number">3</span> Migrasi
                </div>
                <div class="step <?php echo ($step >= 4) ? 'active' : ''; ?> <?php echo ($step > 4) ? 'completed' : ''; ?>">
                    <span class="step-number">4</span> Optimasi
                </div>
                <div class="step <?php echo ($step >= 5) ? 'active' : ''; ?>">
                    <span class="step-number">5</span> Selesai
                </div>
            </div>
            
            <?php if (!empty($message)): ?>
            <div class="alert alert-success"><?php echo $message; ?></div>
            <?php endif; ?>
            
            <?php if (!empty($error)): ?>
            <div class="alert alert-danger"><?php echo $error; ?></div>
            <?php endif; ?>
            
            <div class="step-content">
                <?php switch($step): 
                    case 1: ?>
                        <h3>Konfigurasi Database</h3>
                        <p>Masukkan detail koneksi database MySQL Anda:</p>
                        
                        <?php if (!$requirements['php_version']): ?>
                        <div class="alert alert-danger">PHP versi 8.0 atau lebih tinggi diperlukan. Versi Anda: <?php echo PHP_VERSION; ?></div>
                        <?php endif; ?>
                        
                        <?php if (!$requirements['composer']): ?>
                        <div class="alert alert-danger">File composer.json tidak ditemukan.</div>
                        <?php endif; ?>
                        
                        <?php if (!$requirements['env_file']): ?>
                        <div class="alert alert-danger">File .env.example tidak ditemukan.</div>
                        <?php endif; ?>
                        
                        <?php if (!$requirements['storage_writable']): ?>
                        <div class="alert alert-danger">Direktori storage tidak dapat ditulis.</div>
                        <?php endif; ?>
                        
                        <?php if (!$requirements['bootstrap_cache_writable']): ?>
                        <div class="alert alert-danger">Direktori bootstrap/cache tidak dapat ditulis.</div>
                        <?php endif; ?>
                        
                        <?php if ($requirements['php_version'] && $requirements['composer'] && $requirements['env_file'] && $requirements['storage_writable'] && $requirements['bootstrap_cache_writable']): ?>
                        <form method="post" action="">
                            <div class="mb-3">
                                <label for="db_host" class="form-label">Host Database</label>
                                <input type="text" class="form-control" id="db_host" name="db_host" value="localhost" required>
                            </div>
                            <div class="mb-3">
                                <label for="db_name" class="form-label">Nama Database</label>
                                <input type="text" class="form-control" id="db_name" name="db_name" required>
                            </div>
                            <div class="mb-3">
                                <label for="db_user" class="form-label">Username Database</label>
                                <input type="text" class="form-control" id="db_user" name="db_user" required>
                            </div>
                            <div class="mb-3">
                                <label for="db_pass" class="form-label">Password Database</label>
                                <input type="password" class="form-control" id="db_pass" name="db_pass">
                            </div>
                            <button type="submit" class="btn btn-primary">Lanjutkan</button>
                        </form>
                        <?php else: ?>
                        <div class="alert alert-warning">Harap perbaiki masalah di atas sebelum melanjutkan.</div>
                        <?php endif; ?>
                    <?php break; 
                    
                    case 2: ?>
                        <h3>Instalasi Dependensi</h3>
                        <p>Sistem akan menginstal semua dependensi yang diperlukan menggunakan Composer.</p>
                        <div class="alert alert-info">Proses ini mungkin memerlukan waktu beberapa menit.</div>
                        <form method="post" action="">
                            <button type="submit" class="btn btn-primary">Instal Dependensi</button>
                        </form>
                    <?php break; 
                    
                    case 3: ?>
                        <h3>Migrasi Database</h3>
                        <p>Sistem akan membuat struktur database dan mengisi data awal.</p>
                        <form method="post" action="">
                            <div class="form-check mb-3">
                                <input class="form-check-input" type="checkbox" id="with_seed" name="with_seed" checked>
                                <label class="form-check-label" for="with_seed">
                                    Isi database dengan data awal (seeder)
                                </label>
                            </div>
                            <button type="submit" class="btn btn-primary">Jalankan Migrasi</button>
                        </form>
                    <?php break; 
                    
                    case 4: ?>
                        <h3>Optimasi Aplikasi</h3>
                        <p>Sistem akan mengoptimalkan konfigurasi dan cache untuk performa terbaik.</p>
                        <form method="post" action="">
                            <button type="submit" class="btn btn-primary">Optimasi Aplikasi</button>
                        </form>
                    <?php break; 
                    
                    case 5: ?>
                        <h3>Instalasi Selesai!</h3>
                        <div class="alert alert-success">
                            <p><strong>Selamat!</strong> Sistem Omika Bangun Mandiri telah berhasil diinstal.</p>
                        </div>
                        <p>Anda sekarang dapat mengakses sistem dengan mengklik tombol di bawah ini:</p>
                        <a href="<?php echo $baseUrl; ?>" class="btn btn-success">Buka Aplikasi</a>
                        
                        <div class="mt-4 alert alert-warning">
                            <p><strong>Penting:</strong> Untuk alasan keamanan, harap hapus file installer ini (install.php) dari server Anda.</p>
                        </div>
                    <?php break; 
                    
                    default: ?>
                        <div class="alert alert-danger">Langkah tidak valid.</div>
                <?php endswitch; ?>
            </div>
        </div>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>