<x-app-layout>
    <x-slot name="header">
        <div class="flex justify-between items-center">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">
                {{ __('Detail Pengumuman') }}
            </h2>
            <div>
                <a href="{{ route('announcements.edit', $announcement) }}" class="bg-yellow-500 hover:bg-yellow-700 text-white font-bold py-2 px-4 rounded mr-2">
                    <i class="fas fa-edit mr-1"></i> Edit
                </a>
                <a href="{{ route('announcements.index') }}" class="bg-gray-500 hover:bg-gray-700 text-white font-bold py-2 px-4 rounded">
                    <i class="fas fa-arrow-left mr-1"></i> Kembali
                </a>
            </div>
        </div>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 bg-white border-b border-gray-200">
                    <div class="mb-6">
                        <div class="flex items-center mb-2">
                            @if($announcement->type == 'news')
                                <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-blue-100 text-blue-800 mr-2">
                                    <i class="fas fa-newspaper mr-1"></i> Berita
                                </span>
                            @elseif($announcement->type == 'reminder')
                                <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-yellow-100 text-yellow-800 mr-2">
                                    <i class="fas fa-bell mr-1"></i> Reminder
                                </span>
                            @else
                                <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-red-100 text-red-800 mr-2">
                                    <i class="fas fa-exclamation-triangle mr-1"></i> Alert
                                </span>
                            @endif
                            
                            @if($announcement->is_active)
                                <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-green-100 text-green-800">Aktif</span>
                            @else
                                <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-gray-100 text-gray-800">Tidak Aktif</span>
                            @endif
                        </div>
                        
                        <h1 class="text-2xl font-bold text-gray-800 mb-2">{{ $announcement->title }}</h1>
                        
                        <div class="text-sm text-gray-500 mb-4">
                            <span>Dibuat: {{ $announcement->created_at->format('d M Y H:i') }}</span>
                            @if($announcement->created_at != $announcement->updated_at)
                                <span class="ml-2">Diperbarui: {{ $announcement->updated_at->format('d M Y H:i') }}</span>
                            @endif
                        </div>
                        
                        <div class="text-sm text-gray-500 mb-4">
                            <span>Periode: 
                                @if($announcement->start_date && $announcement->end_date)
                                    {{ $announcement->start_date->format('d M Y') }} - {{ $announcement->end_date->format('d M Y') }}
                                @elseif($announcement->start_date)
                                    Dari {{ $announcement->start_date->format('d M Y') }}
                                @elseif($announcement->end_date)
                                    Sampai {{ $announcement->end_date->format('d M Y') }}
                                @else
                                    Tidak ada batas waktu
                                @endif
                            </span>
                        </div>
                        
                        <div class="border-t border-gray-200 pt-4 mt-4">
                            <div class="prose max-w-none">
                                {{ $announcement->content }}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>