<x-app-layout>
    <x-slot name="header">
        <div class="flex justify-between items-center">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">
                {{ __('Manajemen Bahan Bakar') }}
            </h2>
            <div class="flex space-x-2">
                <button id="btnAddStock" class="bg-green-600 hover:bg-green-700 text-white font-bold py-2 px-4 rounded">
                    <i class="fas fa-plus mr-2"></i>Tambah Stok
                </button>
                <button id="btnReduceStock" class="bg-red-600 hover:bg-red-700 text-white font-bold py-2 px-4 rounded">
                    <i class="fas fa-minus mr-2"></i>Kurangi Stok
                </button>
                <a href="{{ route('fuel-purchases.create') }}" class="bg-indigo-600 hover:bg-indigo-700 text-white font-bold py-2 px-4 rounded">
                    <i class="fas fa-plus mr-2"></i>Tambah Pembelian
                </a>
            </div>
        </div>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <!-- Modal Tambah Stok -->
            <!-- Modal Tambah Stok -->
            <div id="modalAddStock" class="fixed inset-0 bg-gray-600 bg-opacity-50 hidden overflow-y-auto h-full w-full z-50">
                <div class="relative top-20 mx-auto p-5 border w-96 shadow-lg rounded-md bg-white">
                    <div class="mt-3 text-center">
                        <h3 class="text-lg leading-6 font-medium text-gray-900">Tambah Stok BBM</h3>
                        <form action="{{ route('fuel-purchases.stock') }}" method="POST" class="mt-4 text-left" id="formAddStock">
                            @csrf
                            <input type="hidden" name="action" value="add_stock">
                            <div class="mb-4">
                                <label for="fuel_type" class="block text-sm font-medium text-gray-700 mb-1">Jenis BBM</label>
                                <select id="fuel_type" name="fuel_type" class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50" required>
                                    <option value="Solar">Solar</option>
                                    <option value="Bensin">Bensin</option>
                                    <option value="Pertamax">Pertamax</option>
                                </select>
                            </div>
                            <div class="mb-4">
                                <label for="quantity" class="block text-sm font-medium text-gray-700 mb-1">Jumlah (Liter)</label>
                                <input type="number" id="quantity" name="quantity" step="0.01" min="0" class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50" required>
                            </div>
                            <div class="mb-4">
                                <label for="notes" class="block text-sm font-medium text-gray-700 mb-1">Catatan</label>
                                <textarea id="notes" name="notes" rows="2" class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50"></textarea>
                            </div>
                            <div class="flex justify-between mt-6">
                                <button type="button" class="bg-gray-500 hover:bg-gray-600 text-white font-bold py-2 px-4 rounded closeModal">
                                    Batal
                                </button>
                                <button type="submit" class="bg-green-600 hover:bg-green-700 text-white font-bold py-2 px-4 rounded">
                                    Simpan
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

            <!-- Modal Kurangi Stok -->
            <div id="modalReduceStock" class="fixed inset-0 bg-gray-600 bg-opacity-50 hidden overflow-y-auto h-full w-full z-50">
                <div class="relative top-20 mx-auto p-5 border w-96 shadow-lg rounded-md bg-white">
                    <div class="mt-3 text-center">
                        <h3 class="text-lg leading-6 font-medium text-gray-900">Kurangi Stok BBM</h3>
                        <form action="{{ route('fuel-purchases.stock') }}" method="POST" class="mt-4 text-left" id="formReduceStock">
                            @csrf
                            <input type="hidden" name="action" value="reduce_stock">
                            <div class="mb-4">
                                <label for="fuel_type_reduce" class="block text-sm font-medium text-gray-700 mb-1">Jenis BBM</label>
                                <select id="fuel_type_reduce" name="fuel_type" class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50" required>
                                    <option value="Solar">Solar</option>
                                    <option value="Bensin">Bensin</option>
                                    <option value="Pertamax">Pertamax</option>
                                </select>
                            </div>
                            <div class="mb-4">
                                <label for="quantity_reduce" class="block text-sm font-medium text-gray-700 mb-1">Jumlah (Liter)</label>
                                <input type="number" id="quantity_reduce" name="quantity" step="0.01" min="0" class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50" required>
                            </div>
                            <div class="mb-4">
                                <label for="notes_reduce" class="block text-sm font-medium text-gray-700 mb-1">Catatan</label>
                                <textarea id="notes_reduce" name="notes" rows="2" class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50"></textarea>
                            </div>
                            <div class="flex justify-between mt-6">
                                <button type="button" class="bg-gray-500 hover:bg-gray-600 text-white font-bold py-2 px-4 rounded closeModal">
                                    Batal
                                </button>
                                <button type="submit" class="bg-red-600 hover:bg-red-700 text-white font-bold py-2 px-4 rounded">
                                    Simpan
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
            
            <!-- Cards Stok BBM dan Pengeluaran -->
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
                <!-- Card Stok BBM Solar -->
                <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                    <div class="p-6 text-gray-900">
                        <h3 class="text-lg font-semibold mb-4">Stok Solar Saat Ini</h3>
                        
                        @php
                            $solarStock = $fuelStocks->where('fuel_type', 'Solar')->first();
                        @endphp
                        
                        @if ($solarStock)
                            <div class="bg-gray-50 p-4 rounded-lg border border-gray-200">
                                <div class="flex justify-between items-center mb-2">
                                    <h4 class="font-medium">{{ $solarStock->fuel_type }}</h4>
                                    <span class="text-xs text-gray-500">Update: {{ $solarStock->last_updated->format('d/m/Y') }}</span>
                                </div>
                                <div class="text-2xl font-bold mb-1">{{ number_format($solarStock->current_stock, 2) }} L</div>
                                <div class="text-sm text-gray-500">
                                    Total Pembelian: {{ isset($fuelPurchasesByType['Solar']) ? number_format($fuelPurchasesByType['Solar']->total_quantity, 2) : '0.00' }} L
                                </div>
                            </div>
                        @else
                            <div class="bg-yellow-50 p-4 rounded-lg border border-yellow-200 text-yellow-700">
                                <p>Belum ada data stok Solar. Stok akan otomatis dihitung saat Anda menambahkan pembelian bahan bakar.</p>
                            </div>
                        @endif
                    </div>
                </div>
                
                <!-- Card Pengeluaran BBM Bulan Berjalan -->
                <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                    <div class="p-6 text-gray-900">
                        <h3 class="text-lg font-semibold mb-4">Pengeluaran Solar (Bulan {{ now()->translatedFormat('F Y') }})</h3>
                        
                        <div class="bg-gray-50 p-4 rounded-lg border border-gray-200">
                            <div class="flex justify-between items-center mb-2">
                                <h4 class="font-medium">Total Penggunaan</h4>
                                <span class="text-xs text-gray-500">Periode: {{ now()->startOfMonth()->format('d/m/Y') }} - {{ now()->endOfMonth()->format('d/m/Y') }}</span>
                            </div>
                            <div class="text-2xl font-bold mb-1 text-blue-600">{{ number_format($solarUsageCurrentMonth, 2) }} L</div>
                            <div class="text-sm text-gray-500">
                                Rata-rata per hari: {{ number_format($solarUsageCurrentMonth / now()->daysInMonth, 2) }} L
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Tabel Pembelian BBM -->
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900">
                    @if (session('success'))
                        <div class="bg-green-100 border-l-4 border-green-500 text-green-700 p-4 mb-4" role="alert">
                            <p>{{ session('success') }}</p>
                        </div>
                    @endif

                    @if (session('error'))
                        <div class="bg-red-100 border-l-4 border-red-500 text-red-700 p-4 mb-4" role="alert">
                            <p>{{ session('error') }}</p>
                        </div>
                    @endif

                    <!-- Form Pencarian dan Filter -->
                    <div class="mb-4">
                        <form action="{{ route('fuel-purchases.index') }}" method="GET" class="grid grid-cols-1 md:grid-cols-4 gap-4 items-end">
                            <div>
                                <label for="search" class="block text-sm font-medium text-gray-700 mb-1">Pencarian</label>
                                <input type="text" id="search" name="search" value="{{ request('search') }}" placeholder="Cari truk/jenis BBM..." class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                            </div>
                            <div>
                                <label for="start_date" class="block text-sm font-medium text-gray-700 mb-1">Tanggal Mulai</label>
                                <input type="date" id="start_date" name="start_date" value="{{ request('start_date') }}" class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                            </div>
                            <div>
                                <label for="end_date" class="block text-sm font-medium text-gray-700 mb-1">Tanggal Akhir</label>
                                <input type="date" id="end_date" name="end_date" value="{{ request('end_date') }}" class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                            </div>
                            <div>
                                <button type="submit" class="w-full bg-blue-600 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded">
                                    <i class="fas fa-filter mr-2"></i>Filter
                                </button>
                            </div>
                        </form>
                    </div>
                    <!-- Akhir Form Pencarian dan Filter -->

                    <!-- Tab Navigation -->
                    <div class="mb-4">
                        <nav class="flex space-x-8" aria-label="Tabs">
                            <button id="tabPurchases" class="tab-button active border-b-2 border-indigo-500 py-2 px-1 text-sm font-medium text-indigo-600">
                                Pembelian BBM
                            </button>
                            <button id="tabManualOps" class="tab-button border-b-2 border-transparent py-2 px-1 text-sm font-medium text-gray-500 hover:text-gray-700 hover:border-gray-300">
                                Operasi Manual Stok
                            </button>
                        </nav>
                    </div>

                    <!-- Tab Content: Pembelian BBM -->
                    <div id="contentPurchases" class="tab-content">
                        <div class="overflow-x-auto">
                            <table class="min-w-full bg-white">
                                <thead class="bg-gray-100">
                                    <tr>
                                        <th class="py-3 px-4 text-left">Tanggal</th>
                                        <th class="py-3 px-4 text-left">Truk</th>
                                        <th class="py-3 px-4 text-left">Jenis BBM</th>
                                        <th class="py-3 px-4 text-left">Jumlah (L)</th>
                                        <th class="py-3 px-4 text-left">Harga/L</th>
                                        <th class="py-3 px-4 text-left">Total</th>
                                        <th class="py-3 px-4 text-left">Aksi</th>
                                    </tr>
                                </thead>
                                <tbody class="divide-y divide-gray-200">
                                    @forelse ($fuelPurchases as $purchase)
                                        <tr class="hover:bg-gray-50">
                                            <td class="py-3 px-4">{{ $purchase->purchase_date->format('d/m/Y') }}</td>
                                            <td class="py-3 px-4">{{ $purchase->truck->plate_number }}</td>
                                            <td class="py-3 px-4">{{ $purchase->fuel_type }}</td>
                                            <td class="py-3 px-4">{{ number_format($purchase->quantity, 2) }}</td>
                                            <td class="py-3 px-4">Rp {{ number_format($purchase->price_per_liter, 0, ',', '.') }}</td>
                                            <td class="py-3 px-4">Rp {{ number_format($purchase->total_cost, 0, ',', '.') }}</td>
                                            <td class="py-3 px-4">
                                                <div class="flex space-x-2">
                                                    <a href="{{ route('fuel-purchases.show', $purchase) }}" class="text-blue-500 hover:text-blue-700">
                                                        <i class="fas fa-eye"></i>
                                                    </a>
                                                    <a href="{{ route('fuel-purchases.edit', $purchase) }}" class="text-yellow-500 hover:text-yellow-700">
                                                        <i class="fas fa-edit"></i>
                                                    </a>
                                                    <form action="{{ route('fuel-purchases.destroy', $purchase) }}" method="POST" class="inline" onsubmit="return confirm('Apakah Anda yakin ingin menghapus data ini?');">
                                                        @csrf
                                                        @method('DELETE')
                                                        <button type="submit" class="text-red-500 hover:text-red-700">
                                                            <i class="fas fa-trash"></i>
                                                        </button>
                                                    </form>
                                                </div>
                                            </td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="7" class="py-3 px-4 text-center">Tidak ada data pembelian bahan bakar</td>
                                        </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>

                        <div class="mt-4">
                            {{ $fuelPurchases->appends(request()->query())->links() }}
                        </div>
                    </div>

                    <!-- Tab Content: Operasi Manual Stok -->
                    <div id="contentManualOps" class="tab-content hidden">
                        <div class="overflow-x-auto">
                            <table class="min-w-full bg-white">
                                <thead class="bg-gray-100">
                                    <tr>
                                        <th class="py-3 px-4 text-left">Tanggal</th>
                                        <th class="py-3 px-4 text-left">Jenis BBM</th>
                                        <th class="py-3 px-4 text-left">Operasi</th>
                                        <th class="py-3 px-4 text-left">Jumlah (L)</th>
                                        <th class="py-3 px-4 text-left">Catatan</th>
                                        <th class="py-3 px-4 text-left">Oleh</th>
                                    </tr>
                                </thead>
                                <tbody class="divide-y divide-gray-200">
                                    @forelse ($fuelStockLogs as $log)
                                        <tr class="hover:bg-gray-50">
                                            <td class="py-3 px-4">{{ $log->operation_date->format('d/m/Y H:i') }}</td>
                                            <td class="py-3 px-4">{{ $log->fuel_type }}</td>
                                            <td class="py-3 px-4">
                                                @if($log->operation_type === 'add')
                                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-green-100 text-green-800">
                                                        <i class="fas fa-plus mr-1"></i> Tambah
                                                    </span>
                                                @else
                                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-red-100 text-red-800">
                                                        <i class="fas fa-minus mr-1"></i> Kurangi
                                                    </span>
                                                @endif
                                            </td>
                                            <td class="py-3 px-4">{{ number_format($log->quantity, 2) }}</td>
                                            <td class="py-3 px-4">{{ $log->notes ?: '-' }}</td>
                                            <td class="py-3 px-4">{{ $log->user->name ?? 'System' }}</td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="6" class="py-3 px-4 text-center">Belum ada operasi manual stok BBM</td>
                                        </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Tombol Tambah Stok
            document.getElementById('btnAddStock').addEventListener('click', function() {
                document.getElementById('modalAddStock').classList.remove('hidden');
            });
            
            // Tombol Kurangi Stok
            document.getElementById('btnReduceStock').addEventListener('click', function() {
                document.getElementById('modalReduceStock').classList.remove('hidden');
            });
            
            // Tombol Close Modal
            document.querySelectorAll('.closeModal').forEach(function(button) {
                button.addEventListener('click', function() {
                    document.getElementById('modalAddStock').classList.add('hidden');
                    document.getElementById('modalReduceStock').classList.add('hidden');
                });
            });
        });
    </script>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // ... existing modal code ...
            
            // Tab functionality
            const tabButtons = document.querySelectorAll('.tab-button');
            const tabContents = document.querySelectorAll('.tab-content');
            
            tabButtons.forEach(button => {
                button.addEventListener('click', function() {
                    const targetId = this.id.replace('tab', 'content');
                    
                    // Remove active class from all tabs
                    tabButtons.forEach(btn => {
                        btn.classList.remove('active', 'border-indigo-500', 'text-indigo-600');
                        btn.classList.add('border-transparent', 'text-gray-500');
                    });
                    
                    // Add active class to clicked tab
                    this.classList.add('active', 'border-indigo-500', 'text-indigo-600');
                    this.classList.remove('border-transparent', 'text-gray-500');
                    
                    // Hide all tab contents
                    tabContents.forEach(content => {
                        content.classList.add('hidden');
                    });
                    
                    // Show target content
                    document.getElementById(targetId).classList.remove('hidden');
                });
            });
        });
    </script>
</x-app-layout>