<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>{{ config('app.name', 'OBM System') }}</title>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">
    
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    
    <style>
        :root {
            --sidebar-width: 13rem;
            --sidebar-collapsed-width: 4rem;
            --header-height: 4rem;
        }

        html, body {
            height: 100%;
            margin: 0;
            padding: 0;
            overflow-x: hidden;
        }

        body {
            font-family: 'Figtree', sans-serif;
            background-color: #f3f4f6;
        }

        /* Header */
        .app-header {
            position: fixed;
            top: 0;
            left: var(--sidebar-width);
            height: 2.5rem;
            right: 0;
            background-color: white;
            box-shadow: 0 1px 3px 0 rgba(0, 0, 0, 0.1);
            z-index: 40;
            transition: left 0.3s ease;
        }

        .app-header.collapsed {
            left: var(--sidebar-collapsed-width);
        }

        /* Main Content */
        .main-content {
            position: relative;
            margin-left: var(--sidebar-width);
            margin-top: var(--header-height);
            min-height: calc(100vh - var(--header-height));
            transition: margin-left 0.3s ease;
            width: auto;
        }

        .main-content.collapsed {
            margin-left: var(--sidebar-collapsed-width);
        }

        @media (max-width: 768px) {
            .app-header {
                width: 100%;
                left: 0;
            }

            .main-content {
                margin-left: 0;
                width: 100%;
            }
        }

        .sidebar-container {
            width: var(--sidebar-width);
            position: fixed;
            top: 0;
            left: 0;
            height: 100vh;
            background-color: #102d61;
            transition: all 0.3s ease;
            z-index: 50;
            overflow-y: auto;
            -ms-overflow-style: none;
            scrollbar-width: none;
            overscroll-behavior: contain;
            -webkit-overflow-scrolling: touch;
        }

        .sidebar-container::-webkit-scrollbar {
            display: none;
        }

        .sidebar-content {
            min-height: min-content;
            height: auto;
            padding-bottom: 2rem;
        }

        .sidebar-container.collapsed {
            width: var(--sidebar-collapsed-width);
        }

        /* Mobile Sidebar */
        @media (max-width: 768px) {
            body.sidebar-open {
                overflow: hidden;
            }

            .sidebar-container {
                position: fixed;
                top: 0;
                left: -100%;
                height: 100vh;
                width: 80%;
                max-width: 20rem;
                z-index: 50;
                transition: left 0.3s ease;
                overflow-y: auto;
            }

            .sidebar-container.mobile-expanded {
                left: 0;
            }

            .sidebar-overlay {
                position: fixed;
                top: 0;
                left: 0;
                right: 0;
                bottom: 0;
                background-color: rgba(0, 0, 0, 0.5);
                z-index: 40;
                opacity: 0;
                visibility: hidden;
                transition: opacity 0.3s ease, visibility 0.3s ease;
            }

            .sidebar-overlay.show {
                opacity: 1;
                visibility: visible;
            }
        }

        .select2-container {
            z-index: 9999;
        }
    </style>
</head>
<body x-data="{ mobileMenuOpen: false }">
    <!-- Floating Expand Button (Desktop Only) -->
    <button 
        x-show="!$store.sidebar.expanded && !mobileMenuOpen"
        @click="$store.sidebar.toggle()"
        class="fixed top-4 left-2 z-50 bg-indigo-700 text-white p-2 rounded-full shadow-lg transition-all duration-200 hidden md:block"
        style="transition: opacity 0.2s;"
    >
        <i class="fas fa-chevron-right"></i>
    </button>
    <div class="min-h-screen bg-gray-100">
        <!-- Header -->
        <header class="app-header" :class="{ 'collapsed': !$store.sidebar.expanded && !mobileMenuOpen }">
            <div class="flex justify-between items-center px-4 h-full">
                <!-- Mobile Menu Button -->
                <button 
                    @click="mobileMenuOpen = !mobileMenuOpen"
                    class="hamburger-btn md:hidden p-2 rounded-lg bg-indigo-600 text-white">
                    <i class="fas" :class="{'fa-bars': !mobileMenuOpen, 'fa-times': mobileMenuOpen}"></i>
                </button>

                <!-- Announcements -->
                <div class="flex-1 mx-4 overflow-hidden">
                    <marquee behavior="scroll" direction="left" class="text-indigo-600">
                        @foreach($announcements as $announcement)
                            <span class="mx-4">
                                @if($announcement->type === 'info')
                                    <i class="fas fa-info-circle mr-2"></i>
                                @elseif($announcement->type === 'warning')
                                    <i class="fas fa-exclamation-triangle mr-2"></i>
                                @elseif($announcement->type === 'success')
                                    <i class="fas fa-check-circle mr-2"></i>
                                @elseif($announcement->type === 'danger')
                                    <i class="fas fa-times-circle mr-2"></i>
                                @endif
                                {{ $announcement->content }}
                            </span>
                        @endforeach
                    </marquee>
                </div>

                <!-- User Menu -->
                <div class="relative" x-data="{ open: false }">
                    <button @click="open = !open" class="flex items-center space-x-2 text-gray-700 hover:text-indigo-600">
                        <span class="hidden md:block">{{ Auth::user()->name }}</span>
                        <i class="fas fa-user-circle text-xl"></i>
                    </button>
                    
                    <div x-show="open" 
                         @click.away="open = false"
                         class="absolute right-0 mt-2 w-48 bg-white rounded-lg shadow-lg py-1 z-50">
                        <a href="{{ route('profile.edit') }}" class="block px-4 py-2 text-sm text-gray-700 hover:bg-indigo-50">
                            <i class="fas fa-user-edit mr-2"></i> Edit Profil
                        </a>
                        <form method="POST" action="{{ route('logout') }}">
                            @csrf
                            <button type="submit" class="w-full text-left px-4 py-2 text-sm text-gray-700 hover:bg-indigo-50">
                                <i class="fas fa-sign-out-alt mr-2"></i> Logout
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </header>

        <!-- Sidebar -->
        <aside class="sidebar-container" 
               :class="{
                   'collapsed': !$store.sidebar.expanded && !mobileMenuOpen,
                   'mobile-expanded': mobileMenuOpen
               }">
            @include('layouts.sidebar')
        </aside>

        <!-- Main Content -->
        <main class="main-content" 
              :class="{ 'collapsed': !$store.sidebar.expanded && !mobileMenuOpen }">
            @if (isset($header))
                <div class="bg-white shadow">
                    <div class="max-w-7xl mx-auto py-6 px-4 sm:px-6 lg:px-8">
                        {{ $header }}
                    </div>
                </div>
            @endif

            <!-- Page Content -->
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-12">
                @yield('content')
                @isset($slot)
                    {{ $slot }}
                @endisset
            </div>
        </main>

        <!-- Sidebar Overlay -->
        <div class="sidebar-overlay" 
             x-show="mobileMenuOpen"
             @click="mobileMenuOpen = false; $store.sidebar.toggleMobile()"
             :class="{ 'show': mobileMenuOpen }"></div>
    </div>

    <script>
        document.addEventListener('alpine:init', () => {
            Alpine.store('sidebar', {
                expanded: true,
                activeMenu: null,
                toggle() {
                    this.expanded = !this.expanded;
                    document.querySelector('.app-header').classList.toggle('collapsed');
                    document.querySelector('.main-content').classList.toggle('collapsed');
                    document.querySelector('.sidebar-container').style.width = 
                        this.expanded ? 'var(--sidebar-width)' : 'var(--sidebar-collapsed-width)';
                },
                toggleMobile() {
                    document.querySelector('.sidebar-container').classList.toggle('mobile-expanded');
                    document.querySelector('.sidebar-overlay').classList.toggle('show');
                    document.body.classList.toggle('sidebar-open');
                },
                closeOtherMenus(currentMenu) {
    // Dapatkan semua elemen dropdown menu yang memiliki x-data dengan menuOpen
    document.querySelectorAll('[x-data*="menuOpen"]').forEach(menu => {
        // Jika bukan menu yang sedang diklik
        if (menu !== currentMenu) {
            // Untuk Alpine.js v3
            if (menu.__x && menu.__x.$data && typeof menu.__x.$data.menuOpen !== 'undefined') {
                menu.__x.$data.menuOpen = false;
            }
        }
    });
    this.activeMenu = currentMenu;
}
            });
        });
    </script>
</body>
</html>
<script>
    document.addEventListener('alpine:init', () => {
        Alpine.store('sidebar', {
            expanded: true,
            activeMenu: null,
            toggle() {
                this.expanded = !this.expanded;
                document.querySelector('.app-header').classList.toggle('collapsed');
                document.querySelector('.main-content').classList.toggle('collapsed');
                document.querySelector('.sidebar-container').style.width = 
                    this.expanded ? 'var(--sidebar-width)' : 'var(--sidebar-collapsed-width)';
            },
            toggleMobile() {
                document.querySelector('.sidebar-container').classList.toggle('mobile-expanded');
                document.querySelector('.sidebar-overlay').classList.toggle('show');
                document.body.classList.toggle('sidebar-open');
            },
            closeOtherMenus(currentMenu) {
                // Dapatkan semua elemen dropdown menu yang memiliki x-data dengan menuOpen
                document.querySelectorAll('[x-data*="menuOpen"]').forEach(menu => {
                    // Jika bukan menu yang sedang diklik
                    if (menu !== currentMenu) {
                        // Akses Alpine instance dan set menuOpen ke false
                        if (menu.__x && menu.__x.$data && typeof menu.__x.$data.menuOpen !== 'undefined') {
    menu.__x.$data.menuOpen = false;
}
                    }
                });
                this.activeMenu = currentMenu;
            }
        });
    });
</script>

<!-- jQuery dan Select2 -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

@stack('scripts')
</body>
</html>
</body>
</html>
