<x-app-layout>
    <x-slot name="header">
        <div class="flex justify-between items-center">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">
                {{ __('Tambah Retase Manual') }} - {{ $driver->name }}
            </h2>
            <a href="{{ route('drivers.show', $driver) }}" class="bg-gray-500 hover:bg-gray-700 text-white font-bold py-2 px-4 rounded">
                <i class="fas fa-arrow-left mr-2"></i>Kembali
            </a>
        </div>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900">
                    <form method="POST" action="{{ route('drivers.manual-trip-counts.store', $driver) }}">
                        @csrf

                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <!-- Jumlah Perjalanan Selesai -->
                            <div>
                                <x-input-label for="completed_trips" :value="__('Jumlah Perjalanan Selesai')" />
                                <x-text-input id="completed_trips" class="block mt-1 w-full" type="number" name="completed_trips" :value="old('completed_trips', 0)" min="0" required />
                                <x-input-error :messages="$errors->get('completed_trips')" class="mt-2" />
                            </div>

                            <!-- Jumlah Perjalanan Berlangsung -->
                            <div>
                                <x-input-label for="ongoing_trips" :value="__('Jumlah Perjalanan Berlangsung')" />
                                <x-text-input id="ongoing_trips" class="block mt-1 w-full" type="number" name="ongoing_trips" :value="old('ongoing_trips', 0)" min="0" required />
                                <x-input-error :messages="$errors->get('ongoing_trips')" class="mt-2" />
                            </div>
                        </div>

                        <!-- Catatan -->
                        <div class="mt-4">
                            <x-input-label for="notes" :value="__('Catatan')" />
                            <textarea id="notes" name="notes" rows="4" class="border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm block mt-1 w-full">{{ old('notes') }}</textarea>
                            <x-input-error :messages="$errors->get('notes')" class="mt-2" />
                            <p class="text-sm text-gray-500 mt-1">Jelaskan alasan penambahan retase manual</p>
                        </div>

                        <div class="flex items-center justify-end mt-4">
                            <x-primary-button>
                                {{ __('Simpan') }}
                            </x-primary-button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>