<x-app-layout>
    <x-slot name="header">
        <div class="flex justify-between items-center">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">
                {{ __('Riwayat Retase Manual') }} - {{ $driver->name }}
            </h2>
            <a href="{{ route('drivers.show', $driver) }}" class="bg-gray-500 hover:bg-gray-700 text-white font-bold py-2 px-4 rounded">
                <i class="fas fa-arrow-left mr-2"></i>Kembali
            </a>
        </div>
    </x-slot>

    <!-- Tambahkan di bagian atas view, setelah header -->
    @if(isset($dates_debug))
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8 mb-4">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900">
                    <h3 class="text-lg font-semibold mb-4">Debug Info</h3>
                    <pre>{{ print_r($dates_debug, true) }}</pre>
                </div>
            </div>
        </div>
    @endif

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            @if($manualTripCounts->count() > 0)
                @foreach($manualTripCounts as $date => $dailyCounts)
                    <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg mb-6">
                        <div class="p-6 text-gray-900">
                            <h3 class="text-lg font-semibold mb-4">{{ \Carbon\Carbon::parse($date)->format('d F Y') }}</h3>
                            
                            <div class="overflow-x-auto">
                                <table class="min-w-full bg-white">
                                    <thead>
                                        <tr>
                                            <th class="py-3 px-4 border-b border-gray-200 bg-gray-50 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Waktu</th>
                                            <th class="py-3 px-4 border-b border-gray-200 bg-gray-50 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Perjalanan Selesai</th>
                                            <th class="py-3 px-4 border-b border-gray-200 bg-gray-50 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Perjalanan Berlangsung</th>
                                            <th class="py-3 px-4 border-b border-gray-200 bg-gray-50 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Total</th>
                                            <th class="py-3 px-4 border-b border-gray-200 bg-gray-50 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Ditambahkan Oleh</th>
                                            <th class="py-3 px-4 border-b border-gray-200 bg-gray-50 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Catatan</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($dailyCounts as $count)
                                            <tr>
                                                <td class="py-4 px-4 border-b border-gray-200">{{ $count->created_at->format('H:i') }}</td>
                                                <td class="py-4 px-4 border-b border-gray-200">{{ $count->completed_trips }}</td>
                                                <td class="py-4 px-4 border-b border-gray-200">{{ $count->ongoing_trips }}</td>
                                                <td class="py-4 px-4 border-b border-gray-200">{{ $count->completed_trips + $count->ongoing_trips }}</td>
                                                <td class="py-4 px-4 border-b border-gray-200">{{ $count->addedBy->name }}</td>
                                                <td class="py-4 px-4 border-b border-gray-200">{{ $count->notes ?? '-' }}</td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                @endforeach
            @else
                <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                    <div class="p-6 text-gray-900">
                        <p class="text-center py-4">Belum ada data retase manual untuk driver ini.</p>
                    </div>
                </div>
            @endif
        </div>
    </div>
</x-app-layout>