<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Laporan Pengeluaran</title>
    <style>
        body { font-family: Arial, sans-serif; font-size: 12px; }
        table { width: 100%; border-collapse: collapse; margin-bottom: 20px; }
        th, td { border: 1px solid #ddd; padding: 8px; text-align: left; }
        th { background-color: #f2f2f2; }
        .header { text-align: center; margin-bottom: 20px; }
        .summary { margin-bottom: 20px; }
        .summary-box { border: 1px solid #ddd; padding: 10px; margin-bottom: 10px; background-color: #f9f9f9; }
        .text-right { text-align: right; }
    </style>
</head>
<body>
    <div class="header">
        <h1>Laporan Pengeluaran</h1>
        <p>Periode: {{ \Carbon\Carbon::parse($startDate)->format('d/m/Y') }} - {{ \Carbon\Carbon::parse($endDate)->format('d/m/Y') }}</p>
    </div>
    
    <div class="summary">
        <h2>Ringkasan</h2>
        <div class="summary-box">
            <p><strong>Total Pengeluaran:</strong> Rp {{ number_format($totalExpenses, 0, ',', '.') }}</p>
            <p><strong>Jumlah Transaksi:</strong> {{ $expenses->count() }}</p>
            <p><strong>Rata-rata Pengeluaran:</strong> 
                @if($expenses->count() > 0)
                    Rp {{ number_format($totalExpenses / $expenses->count(), 0, ',', '.') }}
                @else
                    Rp 0
                @endif
            </p>
        </div>
    </div>
    
    <h2>Daftar Pengeluaran</h2>
    @if($expenses->count() > 0)
        <table>
            <thead>
                <tr>
                    <th>Judul</th>
                    <th>Jumlah</th>
                    <th>Tanggal</th>
                    <th>Kategori</th>
                    <th>Proyek</th>
                    <th>Status</th>
                </tr>
            </thead>
            <tbody>
                @foreach($expenses as $expense)
                    <tr>
                        <td>{{ $expense->title }}</td>
                        <td class="text-right">Rp {{ number_format($expense->amount, 0, ',', '.') }}</td>
                        <td>{{ $expense->expense_date->format('d/m/Y') }}</td>
                        <td>{{ $expense->category }}</td>
                        <td>{{ $expense->project ? $expense->project->name : 'Tidak Ada' }}</td>
                        <td>
                            @if($expense->status == 'draft')
                                Draft
                            @elseif($expense->status == 'approved')
                                Disetujui
                            @elseif($expense->status == 'rejected')
                                Ditolak
                            @endif
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    @else
        <p>Tidak ada data pengeluaran yang sesuai dengan filter.</p>
    @endif
</body>
</html>