<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Laporan Keuangan</title>
    <style>
        body { font-family: Arial, sans-serif; }
        table { width: 100%; border-collapse: collapse; margin-bottom: 20px; }
        th, td { border: 1px solid #ddd; padding: 8px; text-align: left; }
        th { background-color: #f2f2f2; }
        .text-right { text-align: right; }
        .header { margin-bottom: 20px; }
        .summary { margin-bottom: 20px; }
        .summary table { width: 300px; }
    </style>
</head>
<body>
    <div class="header">
        <h1>Laporan Keuangan</h1>
        <p>Periode: {{ \Carbon\Carbon::parse($startDate)->format('d/m/Y') }} - {{ \Carbon\Carbon::parse($endDate)->format('d/m/Y') }}</p>
    </div>
    
    <div class="summary">
        <h2>Ringkasan</h2>
        <table>
            <tr>
                <th>Total Pendapatan</th>
                <td class="text-right">Rp {{ number_format($totalIncomes, 0, ',', '.') }}</td>
            </tr>
            <tr>
                <th>Total Pengeluaran</th>
                <td class="text-right">Rp {{ number_format($totalExpenses, 0, ',', '.') }}</td>
            </tr>
            <tr>
                <th>Saldo</th>
                <td class="text-right">Rp {{ number_format($balance, 0, ',', '.') }}</td>
            </tr>
        </table>
    </div>
    
    <h2>Pendapatan</h2>
    <table>
        <thead>
            <tr>
                <th>Judul</th>
                <th>Tanggal</th>
                <th>Kategori</th>
                <th>Proyek</th>
                <th>Jumlah</th>
            </tr>
        </thead>
        <tbody>
            @forelse ($incomes as $income)
            <tr>
                <td>{{ $income->title }}</td>
                <td>{{ $income->income_date->format('d/m/Y') }}</td>
                <td>{{ $income->category }}</td>
                <td>{{ $income->project ? $income->project->name : 'Tidak ada' }}</td>
                <td class="text-right">Rp {{ number_format($income->amount, 0, ',', '.') }}</td>
            </tr>
            @empty
            <tr>
                <td colspan="5">Tidak ada data pendapatan</td>
            </tr>
            @endforelse
        </tbody>
    </table>
    
    <h2>Pengeluaran</h2>
    <table>
        <thead>
            <tr>
                <th>Judul</th>
                <th>Tanggal</th>
                <th>Kategori</th>
                <th>Proyek</th>
                <th>Status</th>
                <th>Jumlah</th>
            </tr>
        </thead>
        <tbody>
            @forelse ($expenses as $expense)
            <tr>
                <td>{{ $expense->title }}</td>
                <td>{{ $expense->expense_date->format('d/m/Y') }}</td>
                <td>{{ $expense->category }}</td>
                <td>{{ $expense->project ? $expense->project->name : 'Tidak ada' }}</td>
                <td>
                    @if($expense->status == 'draft')
                        Draft
                    @elseif($expense->status == 'approved')
                        Disetujui
                    @elseif($expense->status == 'rejected')
                        Ditolak
                    @endif
                </td>
                <td class="text-right">Rp {{ number_format($expense->amount, 0, ',', '.') }}</td>
            </tr>
            @empty
            <tr>
                <td colspan="6">Tidak ada data pengeluaran</td>
            </tr>
            @endforelse
        </tbody>
    </table>
</body>
</html>