<!DOCTYPE html>
@include('reports.partials.platnomor_helper')
<html>
<head>
    <meta charset="utf-8">
    <title>Laporan Perjalanan</title>
    <style>
        body { font-family: Arial, sans-serif; font-size: 12px; }
        table { width: 100%; border-collapse: collapse; margin-bottom: 20px; }
        th, td { border: 1px solid #ddd; padding: 8px; text-align: left; }
        th { background-color: #f2f2f2; }
        .header { text-align: center; margin-bottom: 20px; }
        .summary { margin-bottom: 20px; }
        .summary-box { border: 1px solid #ddd; padding: 10px; margin-bottom: 10px; background-color: #f9f9f9; }
        .text-right { text-align: right; }
    </style>
</head>
<body>
    <div class="header">
        <h1>Laporan Perjalanan</h1>
        <p>Periode: {{ \Carbon\Carbon::parse($startDate)->format('d/m/Y') }} - {{ \Carbon\Carbon::parse($endDate)->format('d/m/Y') }}</p>
    </div>
    
    <div class="summary">
        <h2>Ringkasan</h2>
        <div class="summary-box">
            <p><strong>Total Perjalanan:</strong> {{ $trips->count() }}</p>
            <p><strong>Total Jarak:</strong> {{ number_format($totalDistance, 0, ',', '.') }} km</p>
            <p><strong>Total Retase:</strong> {{ $trips->sum(fn($trip) => $trip->driverActivities->sum('retase')) }}</p>
            <p><strong>Total Material:</strong> {{ $trips->filter(fn($t) => $t->materialNp)->count() }}</p>
        </div>
    </div>
    
    <h2>Daftar Perjalanan</h2>
    @if($trips->count() > 0)
        <table>
            <thead>
                <tr>
                    <th>Tanggal</th>
                    <th>Truk (Plat Nomor)</th>
                    <th>Driver</th>
                    <th>Dari</th>
                    <th>Tujuan</th>
                    <th>Jarak (km)</th>
                    <th>Retase</th>
                    <th>Material</th>
                </tr>
            </thead>
            <tbody>
                @foreach($trips as $trip)
                    <tr>
                        <td>{{ $trip->start_date->format('d/m/Y') }}</td>
                        <td>{{ getPlatNomor($trip) }}</td>
                        <td>{{ $trip->driver->name }}</td>
                        <td>{{ $trip->origin }}</td>
                        <td>{{ $trip->destination }}</td>
                        <td class="text-right">{{ $trip->distance }}</td>
                        <td class="text-right">{{ $trip->driverActivities->sum('retase') }}</td>
                        <td>{{ optional($trip->materialNp)->name ?? '-' }}</td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    @else
        <p>Tidak ada data perjalanan yang sesuai dengan filter.</p>
    @endif
</body>
</html>