<x-app-layout>
    <x-slot name="header">
        <div class="flex justify-between items-center">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">
                {{ __('Detail Truk') }}
            </h2>
            <div class="flex space-x-2">
                <a href="{{ route('trucks.edit', $truck) }}" class="bg-yellow-500 hover:bg-yellow-700 text-white font-bold py-2 px-4 rounded">
                    <i class="fas fa-edit mr-2"></i>Edit
                </a>
                <a href="{{ route('trucks.index') }}" class="bg-gray-500 hover:bg-gray-700 text-white font-bold py-2 px-4 rounded">
                    <i class="fas fa-arrow-left mr-2"></i>Kembali
                </a>
            </div>
        </div>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div class="bg-gray-50 p-4 rounded-lg">
                            <h3 class="text-lg font-semibold mb-4 border-b pb-2">Informasi Umum</h3>
                            
                            <div class="grid grid-cols-2 gap-4">
                                <div class="text-gray-600">Nomor Plat:</div>
                                <div class="font-medium">{{ $truck->plate_number }}</div>
                                
                                <div class="text-gray-600">Merek:</div>
                                <div class="font-medium">{{ $truck->brand }}</div>
                                
                                <div class="text-gray-600">Model:</div>
                                <div class="font-medium">{{ $truck->model }}</div>
                                
                                <div class="text-gray-600">Tahun:</div>
                                <div class="font-medium">{{ $truck->year }}</div>
                                
                                <div class="text-gray-600">Kapasitas:</div>
                                <div class="font-medium">{{ $truck->capacity }}</div>
                                
                                <div class="text-gray-600">Jenis Bahan Bakar:</div>
                                <div class="font-medium">{{ $truck->fuel_type }}</div>
                                
                                <div class="text-gray-600">Status:</div>
                                <div>
                                    <span class="px-2 py-1 rounded text-xs font-semibold
                                        {{ $truck->status == 'active' ? 'bg-green-100 text-green-800' : '' }}
                                        {{ $truck->status == 'maintenance' ? 'bg-yellow-100 text-yellow-800' : '' }}
                                        {{ $truck->status == 'inactive' ? 'bg-red-100 text-red-800' : '' }}
                                    ">
                                        {{ $truck->status == 'active' ? 'Aktif' : '' }}
                                        {{ $truck->status == 'maintenance' ? 'Maintenance' : '' }}
                                        {{ $truck->status == 'inactive' ? 'Tidak Aktif' : '' }}
                                    </span>
                                </div>
                            </div>
                        </div>
                        
                        <div class="bg-gray-50 p-4 rounded-lg">
                            <h3 class="text-lg font-semibold mb-4 border-b pb-2">Informasi Pemeliharaan</h3>
                            
                            <div class="grid grid-cols-2 gap-4">
                                <div class="text-gray-600">Tanggal Pembelian:</div>
                                <div class="font-medium">{{ $truck->purchase_date->format('d/m/Y') }}</div>
                                
                                <div class="text-gray-600">Service Terakhir:</div>
                                <div class="font-medium">{{ $truck->last_service_date ? $truck->last_service_date->format('d/m/Y') : 'Belum ada' }}</div>
                                
                                <div class="text-gray-600">Service Berikutnya:</div>
                                <div class="font-medium">{{ $truck->next_service_date ? $truck->next_service_date->format('d/m/Y') : 'Belum dijadwalkan' }}</div>
                            </div>
                        </div>
                        
                        <div class="bg-gray-50 p-4 rounded-lg">
                            <h3 class="text-lg font-semibold mb-4 border-b pb-2">Dokumen Kendaraan</h3>
                            
                            <div class="grid grid-cols-2 gap-4">
                                <!-- STNK -->
                                <div class="text-gray-600">Nomor STNK:</div>
                                <div class="font-medium">{{ $truck->stnk_number ?: 'Belum diisi' }}</div>
                                
                                <div class="text-gray-600">Tanggal Berlaku STNK:</div>
                                <div class="font-medium">
                                    @if($truck->stnk_expire_date)
                                        {{ $truck->stnk_expire_date->format('d/m/Y') }}
                                        @php $stnkStatus = $truck->stnk_status; @endphp
                                        @if($stnkStatus)
                                            <span class="ml-2 px-2 py-1 rounded text-xs font-semibold
                                                {{ $stnkStatus['status'] == 'overdue' ? 'bg-red-100 text-red-800' : '' }}
                                                {{ $stnkStatus['status'] == 'warning' ? 'bg-yellow-100 text-yellow-800' : '' }}
                                                {{ $stnkStatus['status'] == 'ok' ? 'bg-green-100 text-green-800' : '' }}">
                                                {{ $stnkStatus['status'] == 'overdue' ? 'Expired '.$stnkStatus['days'].' hari' : '' }}
                                                {{ $stnkStatus['status'] == 'warning' ? 'Expires dalam '.$stnkStatus['days'].' hari' : '' }}
                                                {{ $stnkStatus['status'] == 'ok' ? 'Masih berlaku' : '' }}
                                            </span>
                                        @endif
                                    @else
                                        Belum diisi
                                    @endif
                                </div>
                                
                                <!-- KIR -->
                                <div class="text-gray-600">Nomor KIR:</div>
                                <div class="font-medium">{{ $truck->kir_number ?: 'Belum diisi' }}</div>
                                
                                <div class="text-gray-600">Tanggal Berlaku KIR:</div>
                                <div class="font-medium">
                                    @if($truck->kir_expire_date)
                                        {{ $truck->kir_expire_date->format('d/m/Y') }}
                                        @php $kirStatus = $truck->kir_status; @endphp
                                        @if($kirStatus)
                                            <span class="ml-2 px-2 py-1 rounded text-xs font-semibold
                                                {{ $kirStatus['status'] == 'overdue' ? 'bg-red-100 text-red-800' : '' }}
                                                {{ $kirStatus['status'] == 'warning' ? 'bg-yellow-100 text-yellow-800' : '' }}
                                                {{ $kirStatus['status'] == 'ok' ? 'bg-green-100 text-green-800' : '' }}">
                                                {{ $kirStatus['status'] == 'overdue' ? 'Expired '.$kirStatus['days'].' hari' : '' }}
                                                {{ $kirStatus['status'] == 'warning' ? 'Expires dalam '.$kirStatus['days'].' hari' : '' }}
                                                {{ $kirStatus['status'] == 'ok' ? 'Masih berlaku' : '' }}
                                            </span>
                                        @endif
                                    @else
                                        Belum diisi
                                    @endif
                                </div>
                                
                                <!-- Pajak -->
                                <div class="text-gray-600">Tanggal Berlaku Pajak:</div>
                                <div class="font-medium">
                                    @if($truck->tax_expire_date)
                                        {{ $truck->tax_expire_date->format('d/m/Y') }}
                                        @php $taxStatus = $truck->tax_status; @endphp
                                        @if($taxStatus)
                                            <span class="ml-2 px-2 py-1 rounded text-xs font-semibold
                                                {{ $taxStatus['status'] == 'overdue' ? 'bg-red-100 text-red-800' : '' }}
                                                {{ $taxStatus['status'] == 'warning' ? 'bg-yellow-100 text-yellow-800' : '' }}
                                                {{ $taxStatus['status'] == 'ok' ? 'bg-green-100 text-green-800' : '' }}">
                                                {{ $taxStatus['status'] == 'overdue' ? 'Expired '.$taxStatus['days'].' hari' : '' }}
                                                {{ $taxStatus['status'] == 'warning' ? 'Expires dalam '.$taxStatus['days'].' hari' : '' }}
                                                {{ $taxStatus['status'] == 'ok' ? 'Masih berlaku' : '' }}
                                            </span>
                                        @endif
                                    @else
                                        Belum diisi
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="mt-6 bg-gray-50 p-4 rounded-lg">
                        <h3 class="text-lg font-semibold mb-4 border-b pb-2">Catatan</h3>
                        <p class="whitespace-pre-line">{{ $truck->notes ?: 'Tidak ada catatan' }}</p>
                    </div>
                    
                    <!-- Riwayat Pembelian Bahan Bakar -->
                    <div class="mt-6 bg-gray-50 p-4 rounded-lg">
                        <h3 class="text-lg font-semibold mb-4 border-b pb-2">Riwayat Pembelian Bahan Bakar</h3>
                        
                        @if($truck->fuelPurchases->count() > 0)
                            <div class="overflow-x-auto">
                                <table class="min-w-full bg-white">
                                    <thead class="bg-gray-100">
                                        <tr>
                                            <th class="py-2 px-4 border-b text-left">Tanggal</th>
                                            <th class="py-2 px-4 border-b text-left">Jumlah (L)</th>
                                            <th class="py-2 px-4 border-b text-left">Harga/L</th>
                                            <th class="py-2 px-4 border-b text-left">Total</th>
                                            <th class="py-2 px-4 border-b text-left">SPBU</th>
                                            <th class="py-2 px-4 border-b text-left">Driver</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($truck->fuelPurchases->sortByDesc('purchase_date') as $purchase)
                                            <tr>
                                                <td class="py-2 px-4 border-b">{{ $purchase->purchase_date->format('d/m/Y') }}</td>
                                                <td class="py-2 px-4 border-b">{{ number_format($purchase->quantity, 2) }}</td>
                                                <td class="py-2 px-4 border-b">{{ number_format($purchase->price_per_liter, 0) }}</td>
                                                <td class="py-2 px-4 border-b">{{ number_format($purchase->total_cost, 0) }}</td>
                                                <td class="py-2 px-4 border-b">{{ $purchase->station_name }}</td>
                                                <td class="py-2 px-4 border-b">{{ $purchase->driver_name }}</td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        @else
                            <p class="text-gray-500 italic">Belum ada data pembelian bahan bakar</p>
                        @endif
                    </div>
                    
                    <!-- Riwayat Aktivitas Driver dari Aplikasi -->
                    <div class="mt-6 bg-gray-50 p-4 rounded-lg">
                        <h3 class="text-lg font-semibold mb-4 border-b pb-2">Riwayat Aktivitas Driver</h3>
                        
                        @php
                            $activities = \App\Models\DriverActivity::where('plat_nomor', $truck->plate_number)
                                ->orderBy('hari_tanggal', 'desc')
                                ->get();
                        @endphp
                        
                        @if($activities->count() > 0)
                            <div class="overflow-x-auto">
                                <table class="min-w-full bg-white">
                                    <thead class="bg-gray-100">
                                        <tr>
                                            <th class="py-2 px-4 border-b text-left">Tanggal</th>
                                            <th class="py-2 px-4 border-b text-left">KM Awal</th>
                                            <th class="py-2 px-4 border-b text-left">KM Akhir</th>
                                            <th class="py-2 px-4 border-b text-left">Pengisian Solar</th>
                                            <th class="py-2 px-4 border-b text-left">Indikator Solar</th>
                                            <th class="py-2 px-4 border-b text-left">Retase</th>
                                            <th class="py-2 px-4 border-b text-left">Driver</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($activities as $activity)
                                            <tr>
                                                <td class="py-2 px-4 border-b">{{ $activity->hari_tanggal->format('d/m/Y') }}</td>
                                                <td class="py-2 px-4 border-b">{{ number_format($activity->km_start) }}</td>
                                                <td class="py-2 px-4 border-b">{{ number_format($activity->km_end) }}</td>
                                                <td class="py-2 px-4 border-b">{{ number_format($activity->pengisian_solar) }}</td>
                                                <td class="py-2 px-4 border-b">{{ $activity->indikator_solar }}%</td>
                                                <td class="py-2 px-4 border-b">{{ $activity->retase }}</td>
                                                <td class="py-2 px-4 border-b">{{ $activity->user->name ?? 'Unknown' }}</td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        @else
                            <p class="text-gray-500 italic">Belum ada data aktivitas driver</p>
                        @endif
                    </div>
                    
                    <!-- Riwayat Maintenance -->
                    <div class="mt-6 bg-gray-50 p-4 rounded-lg">
                        <div class="flex justify-between items-center mb-4">
                            <h3 class="text-lg font-semibold border-b pb-2">Riwayat Maintenance</h3>
                            <a href="{{ route('truck-maintenances.create', $truck) }}" class="bg-blue-500 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded">
                                <i class="fas fa-plus mr-2"></i>Tambah Maintenance
                            </a>
                        </div>
                        
                        @if($truck->maintenances->count() > 0)
                            <div class="overflow-x-auto">
                                <table class="min-w-full bg-white">
                                    <thead class="bg-gray-100">
                                        <tr>
                                            <th class="py-2 px-4 border-b text-left">Tanggal</th>
                                            <th class="py-2 px-4 border-b text-left">Tipe</th>
                                            <th class="py-2 px-4 border-b text-left">Deskripsi</th>
                                            <th class="py-2 px-4 border-b text-left">Biaya</th>
                                            <th class="py-2 px-4 border-b text-left">Lokasi</th>
                                            <th class="py-2 px-4 border-b text-left">Status</th>
                                            <th class="py-2 px-4 border-b text-left">Aksi</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($truck->maintenances->sortByDesc('maintenance_date') as $maintenance)
                                            <tr>
                                                <td class="py-2 px-4 border-b">{{ $maintenance->maintenance_date->format('d/m/Y') }}</td>
                                                <td class="py-2 px-4 border-b">{{ ucfirst(str_replace('_', ' ', $maintenance->maintenance_type)) }}</td>
                                                <td class="py-2 px-4 border-b">{{ $maintenance->description }}</td>
                                                <td class="py-2 px-4 border-b">{{ number_format($maintenance->cost, 0) }}</td>
                                                <td class="py-2 px-4 border-b">{{ $maintenance->location }}</td>
                                                <td class="py-2 px-4 border-b">
                                                    <span class="px-2 py-1 rounded text-xs font-semibold
                                                        {{ $maintenance->status == 'completed' ? 'bg-green-100 text-green-800' : '' }}
                                                        {{ $maintenance->status == 'pending' ? 'bg-yellow-100 text-yellow-800' : '' }}
                                                        {{ $maintenance->status == 'in_progress' ? 'bg-blue-100 text-blue-800' : '' }}">
                                                        {{ ucfirst(str_replace('_', ' ', $maintenance->status)) }}
                                                    </span>
                                                </td>
                                                <td class="py-2 px-4 border-b">
                                                    <a href="{{ route('truck-maintenances.edit', ['truck' => $truck, 'maintenance' => $maintenance]) }}" class="text-blue-500 hover:text-blue-700 mr-2">
                                                        <i class="fas fa-edit"></i>
                                                    </a>
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        @else
                            <p class="text-gray-500 italic">Belum ada data maintenance</p>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>