<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Http\Request;

use App\Http\Controllers\ProfileController;
use App\Http\Controllers\TruckController;
use App\Http\Controllers\DriverController;
use App\Http\Controllers\FuelPurchaseController;
use App\Http\Controllers\TripController; 
use App\Http\Controllers\ProjectController;
use App\Http\Controllers\MaterialController;
use App\Http\Controllers\ClientController;
use App\Http\Controllers\ExpenseController;
use App\Http\Controllers\AnnouncementController;
use App\Http\Controllers\ManualTripCountController;
use App\Http\Controllers\ReportController;
use App\Http\Controllers\IncomeController;
use App\Http\Controllers\TruckMaintenanceController;

use App\Models\Driver;

Route::get('/', function () {
    return redirect()->route('login');
});

require __DIR__.'/auth.php';

Route::get('/dashboard', [App\Http\Controllers\DashboardController::class, 'index'])
    ->middleware(['auth', 'verified'])
    ->name('dashboard');

Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
    
    Route::resource('trucks', TruckController::class);
    Route::resource('drivers', DriverController::class);
    Route::resource('fuel-purchases', FuelPurchaseController::class);
    
    Route::get('/api/drivers-by-truck/{truck}', function($truck) {
        return Driver::where('truck_id', $truck)->get();
    });

    Route::resource('trips', TripController::class);
    Route::resource('projects', ProjectController::class);
    Route::resource('materials', MaterialController::class);
    Route::resource('clients', ClientController::class);
    Route::resource('expenses', ExpenseController::class);
    Route::resource('announcements', AnnouncementController::class);

    Route::get('/reports/trips', [ReportController::class, 'trips'])->name('reports.trips');
    Route::get('/reports/fuel', [ReportController::class, 'fuel'])->name('reports.fuel');
    Route::get('/reports/expenses', function() {
        return view('reports.expenses');
    })->name('reports.expenses');
    Route::get('/reports/projects', function() {
        return view('reports.projects');
    })->name('reports.projects');
});

Route::middleware(['auth', 'permission:access-settings'])->group(function () {
    Route::get('/settings', [App\Http\Controllers\SettingController::class, 'index'])->name('settings.index');
    Route::post('/settings', [App\Http\Controllers\SettingController::class, 'update'])->name('settings.update');
    Route::post('/settings/reset', [App\Http\Controllers\SettingController::class, 'reset'])->name('settings.reset');
    Route::post('/settings/test-email', [App\Http\Controllers\SettingController::class, 'testEmail'])->name('settings.test-email');
    Route::get('/settings/export', [App\Http\Controllers\SettingController::class, 'export'])->name('settings.export');
    Route::post('/settings/import', [App\Http\Controllers\SettingController::class, 'import'])->name('settings.import');
    Route::get('/settings/update-timezone-to-select', [App\Http\Controllers\SettingController::class, 'updateTimezoneToSelect'])->name('settings.update-timezone-to-select');
});

Route::middleware(['auth', 'permission:manage-users'])->group(function () {
    Route::resource('users', App\Http\Controllers\UserController::class);
});

Route::middleware(['auth', 'permission:manage-roles'])->group(function () {
    Route::resource('roles', App\Http\Controllers\RoleController::class);
});

Route::middleware(['auth', 'permission:manage-permissions'])->group(function () {
    Route::resource('permissions', App\Http\Controllers\PermissionController::class);
});

Route::middleware(['auth'])->group(function () {
    Route::get('/drivers/{driver}/manual-trip-counts/create', [ManualTripCountController::class, 'create'])->name('drivers.manual-trip-counts.create');
    Route::post('/drivers/{driver}/manual-trip-counts', [ManualTripCountController::class, 'store'])->name('drivers.manual-trip-counts.store');
    Route::get('/drivers/{driver}/manual-trip-counts/history', [ManualTripCountController::class, 'history'])->name('drivers.manual-trip-counts.history');
});

Route::middleware(['auth'])->group(function () {
    Route::get('/incomes/export', [IncomeController::class, 'export'])->name('incomes.export');
    Route::resource('incomes', IncomeController::class);
    Route::get('expenses/export', [ExpenseController::class, 'export'])->name('expenses.export');
    Route::resource('expenses', ExpenseController::class);

    Route::get('/reports/financial', [ReportController::class, 'financial'])->name('reports.financial');
    Route::get('/reports/expenses', [ReportController::class, 'expenses'])->name('reports.expenses');
    Route::get('/reports/trips', [ReportController::class, 'trips'])->name('reports.trips');
    Route::get('/reports/fuel', [ReportController::class, 'fuel'])->name('reports.fuel');
    Route::get('/reports/projects', [ReportController::class, 'projects'])->name('reports.projects');

    Route::get('/reports/financial/export/excel', [ReportController::class, 'exportFinancialExcel'])->name('reports.financial.export.excel');
    Route::get('/reports/financial/export/pdf', [ReportController::class, 'exportFinancialPDF'])->name('reports.financial.export.pdf');

    Route::get('/reports/expenses/export/excel', [ReportController::class, 'exportExpensesExcel'])->name('reports.expenses.export.excel');
    Route::get('/reports/expenses/export/pdf', [ReportController::class, 'exportExpensesPDF'])->name('reports.expenses.export.pdf');

    Route::get('/reports/trips/export/excel', [ReportController::class, 'exportTripsExcel'])->name('reports.trips.export.excel');
    Route::get('/reports/trips/export/pdf', [ReportController::class, 'exportTripsPDF'])->name('reports.trips.export.pdf');

    Route::get('/reports/fuel/export/excel', [ReportController::class, 'exportFuelExcel'])->name('reports.fuel.export.excel');
    Route::get('/reports/fuel/export/pdf', [ReportController::class, 'exportFuelPDF'])->name('reports.fuel.export.pdf');

    Route::get('/reports/projects/export/excel', [ReportController::class, 'exportProjectsExcel'])->name('reports.projects.export.excel');
    Route::get('/reports/projects/export/pdf', [ReportController::class, 'exportProjectsPDF'])->name('reports.projects.export.pdf');

    Route::patch('/expenses/{expense}/approve', [ExpenseController::class, 'approve'])->name('expenses.approve');
    Route::patch('/expenses/{expense}/reject', [ExpenseController::class, 'reject'])->name('expenses.reject');

    Route::patch('/incomes/{income}/approve', [IncomeController::class, 'approve'])->name('incomes.approve');
    Route::patch('/incomes/{income}/reject', [IncomeController::class, 'reject'])->name('incomes.reject');
});

Route::resource('material-np', App\Http\Controllers\MaterialNpController::class);

// Truck Maintenance Routes
Route::middleware(['auth'])->group(function () {
    Route::get('/truck-maintenances', [TruckMaintenanceController::class, 'allMaintenances'])->name('truck-maintenances.all');
    Route::get('/trucks/{truck}/maintenances/create', [TruckMaintenanceController::class, 'create'])->name('truck-maintenances.create');
    Route::post('/trucks/{truck}/maintenances', [TruckMaintenanceController::class, 'store'])->name('truck-maintenances.store');
    Route::get('/trucks/{truck}/maintenances', [TruckMaintenanceController::class, 'index'])->name('truck-maintenances.index');
    Route::get('/trucks/{truck}/maintenances/{maintenance}/edit', [TruckMaintenanceController::class, 'edit'])->name('truck-maintenances.edit');
    Route::put('/trucks/{truck}/maintenances/{maintenance}', [TruckMaintenanceController::class, 'update'])->name('truck-maintenances.update');
    Route::get('/trucks/{truck}/maintenances/{maintenance}', [TruckMaintenanceController::class, 'show'])->name('truck-maintenances.show');
    Route::delete('/trucks/{truck}/maintenances/{maintenance}', [TruckMaintenanceController::class, 'destroy'])->name('truck-maintenances.destroy');
});

Route::get('/driver-activities', [DriverActivityController::class, 'getDriverActivitiesGrouped'])->name('driver-activities.index');
Route::get('/drivers/{driver}/activities', [DriverActivityController::class, 'getDriverActivitiesGrouped'])->name('drivers.activities.index');
Route::get('/trucks/{truck}/activities', [DriverActivityController::class, 'getDriverActivitiesGrouped'])->name('trucks.activities.index');

// Manual Notification Routes - Terpisah
Route::post('/trucks/{truck}/maintenances/{maintenance}/send-push-notification', [TruckMaintenanceController::class, 'sendManualPushNotification'])->name('truck-maintenances.send-push-notification');
Route::post('/trucks/{truck}/maintenances/{maintenance}/send-inapp-message', [TruckMaintenanceController::class, 'sendManualInAppMessage'])->name('truck-maintenances.send-inapp-message');
Route::post('/truck-maintenances/send-bulk-notification', [TruckMaintenanceController::class, 'sendBulkNotification'])->name('truck-maintenances.send-bulk-notification');

// Tambahkan route ini di dalam grup yang sama dengan route fuel-purchases lainnya
Route::post('fuel-purchases/stock', [FuelPurchaseController::class, 'handleStockOperation'])->name('fuel-purchases.stock');
