<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AppLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('header', null, []); ?> 
        <div class="flex justify-between items-center">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">
                <?php echo e(__('Manajemen Bahan Bakar')); ?>

            </h2>
            <div class="flex space-x-2">
                <button id="btnAddStock" class="bg-green-600 hover:bg-green-700 text-white font-bold py-2 px-4 rounded">
                    <i class="fas fa-plus mr-2"></i>Tambah Stok
                </button>
                <button id="btnReduceStock" class="bg-red-600 hover:bg-red-700 text-white font-bold py-2 px-4 rounded">
                    <i class="fas fa-minus mr-2"></i>Kurangi Stok
                </button>
                <a href="<?php echo e(route('fuel-purchases.create')); ?>" class="bg-indigo-600 hover:bg-indigo-700 text-white font-bold py-2 px-4 rounded">
                    <i class="fas fa-plus mr-2"></i>Tambah Pembelian
                </a>
            </div>
        </div>
     <?php $__env->endSlot(); ?>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <!-- Modal Tambah Stok -->
            <!-- Modal Tambah Stok -->
            <div id="modalAddStock" class="fixed inset-0 bg-gray-600 bg-opacity-50 hidden overflow-y-auto h-full w-full z-50">
                <div class="relative top-20 mx-auto p-5 border w-96 shadow-lg rounded-md bg-white">
                    <div class="mt-3 text-center">
                        <h3 class="text-lg leading-6 font-medium text-gray-900">Tambah Stok BBM</h3>
                        <form action="<?php echo e(route('fuel-purchases.stock')); ?>" method="POST" class="mt-4 text-left" id="formAddStock">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="action" value="add_stock">
                            <div class="mb-4">
                                <label for="fuel_type" class="block text-sm font-medium text-gray-700 mb-1">Jenis BBM</label>
                                <select id="fuel_type" name="fuel_type" class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50" required>
                                    <option value="Solar">Solar</option>
                                    <option value="Bensin">Bensin</option>
                                    <option value="Pertamax">Pertamax</option>
                                </select>
                            </div>
                            <div class="mb-4">
                                <label for="quantity" class="block text-sm font-medium text-gray-700 mb-1">Jumlah (Liter)</label>
                                <input type="number" id="quantity" name="quantity" step="0.01" min="0" class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50" required>
                            </div>
                            <div class="mb-4">
                                <label for="notes" class="block text-sm font-medium text-gray-700 mb-1">Catatan</label>
                                <textarea id="notes" name="notes" rows="2" class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50"></textarea>
                            </div>
                            <div class="flex justify-between mt-6">
                                <button type="button" class="bg-gray-500 hover:bg-gray-600 text-white font-bold py-2 px-4 rounded closeModal">
                                    Batal
                                </button>
                                <button type="submit" class="bg-green-600 hover:bg-green-700 text-white font-bold py-2 px-4 rounded">
                                    Simpan
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

            <!-- Modal Kurangi Stok -->
            <div id="modalReduceStock" class="fixed inset-0 bg-gray-600 bg-opacity-50 hidden overflow-y-auto h-full w-full z-50">
                <div class="relative top-20 mx-auto p-5 border w-96 shadow-lg rounded-md bg-white">
                    <div class="mt-3 text-center">
                        <h3 class="text-lg leading-6 font-medium text-gray-900">Kurangi Stok BBM</h3>
                        <form action="<?php echo e(route('fuel-purchases.stock')); ?>" method="POST" class="mt-4 text-left" id="formReduceStock">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="action" value="reduce_stock">
                            <div class="mb-4">
                                <label for="fuel_type_reduce" class="block text-sm font-medium text-gray-700 mb-1">Jenis BBM</label>
                                <select id="fuel_type_reduce" name="fuel_type" class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50" required>
                                    <option value="Solar">Solar</option>
                                    <option value="Bensin">Bensin</option>
                                    <option value="Pertamax">Pertamax</option>
                                </select>
                            </div>
                            <div class="mb-4">
                                <label for="quantity_reduce" class="block text-sm font-medium text-gray-700 mb-1">Jumlah (Liter)</label>
                                <input type="number" id="quantity_reduce" name="quantity" step="0.01" min="0" class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50" required>
                            </div>
                            <div class="mb-4">
                                <label for="notes_reduce" class="block text-sm font-medium text-gray-700 mb-1">Catatan</label>
                                <textarea id="notes_reduce" name="notes" rows="2" class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50"></textarea>
                            </div>
                            <div class="flex justify-between mt-6">
                                <button type="button" class="bg-gray-500 hover:bg-gray-600 text-white font-bold py-2 px-4 rounded closeModal">
                                    Batal
                                </button>
                                <button type="submit" class="bg-red-600 hover:bg-red-700 text-white font-bold py-2 px-4 rounded">
                                    Simpan
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
            
            <!-- Cards Stok BBM dan Pengeluaran -->
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
                <!-- Card Stok BBM Solar -->
                <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                    <div class="p-6 text-gray-900">
                        <h3 class="text-lg font-semibold mb-4">Stok Solar Saat Ini</h3>
                        
                        <?php
                            $solarStock = $fuelStocks->where('fuel_type', 'Solar')->first();
                        ?>
                        
                        <?php if($solarStock): ?>
                            <div class="bg-gray-50 p-4 rounded-lg border border-gray-200">
                                <div class="flex justify-between items-center mb-2">
                                    <h4 class="font-medium"><?php echo e($solarStock->fuel_type); ?></h4>
                                    <span class="text-xs text-gray-500">Update: <?php echo e($solarStock->last_updated->format('d/m/Y')); ?></span>
                                </div>
                                <div class="text-2xl font-bold mb-1"><?php echo e(number_format($solarStock->current_stock, 2)); ?> L</div>
                                <div class="text-sm text-gray-500">
                                    Total Pembelian: <?php echo e(isset($fuelPurchasesByType['Solar']) ? number_format($fuelPurchasesByType['Solar']->total_quantity, 2) : '0.00'); ?> L
                                </div>
                            </div>
                        <?php else: ?>
                            <div class="bg-yellow-50 p-4 rounded-lg border border-yellow-200 text-yellow-700">
                                <p>Belum ada data stok Solar. Stok akan otomatis dihitung saat Anda menambahkan pembelian bahan bakar.</p>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
                
                <!-- Card Pengeluaran BBM Bulan Berjalan -->
                <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                    <div class="p-6 text-gray-900">
                        <h3 class="text-lg font-semibold mb-4">Pengeluaran Solar (Bulan <?php echo e(now()->translatedFormat('F Y')); ?>)</h3>
                        
                        <div class="bg-gray-50 p-4 rounded-lg border border-gray-200">
                            <div class="flex justify-between items-center mb-2">
                                <h4 class="font-medium">Total Penggunaan</h4>
                                <span class="text-xs text-gray-500">Periode: <?php echo e(now()->startOfMonth()->format('d/m/Y')); ?> - <?php echo e(now()->endOfMonth()->format('d/m/Y')); ?></span>
                            </div>
                            <div class="text-2xl font-bold mb-1 text-blue-600"><?php echo e(number_format($solarUsageCurrentMonth, 2)); ?> L</div>
                            <div class="text-sm text-gray-500">
                                Rata-rata per hari: <?php echo e(number_format($solarUsageCurrentMonth / now()->daysInMonth, 2)); ?> L
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Tabel Pembelian BBM -->
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900">
                    <?php if(session('success')): ?>
                        <div class="bg-green-100 border-l-4 border-green-500 text-green-700 p-4 mb-4" role="alert">
                            <p><?php echo e(session('success')); ?></p>
                        </div>
                    <?php endif; ?>

                    <?php if(session('error')): ?>
                        <div class="bg-red-100 border-l-4 border-red-500 text-red-700 p-4 mb-4" role="alert">
                            <p><?php echo e(session('error')); ?></p>
                        </div>
                    <?php endif; ?>

                    <!-- Form Pencarian dan Filter -->
                    <div class="mb-4">
                        <form action="<?php echo e(route('fuel-purchases.index')); ?>" method="GET" class="grid grid-cols-1 md:grid-cols-4 gap-4 items-end">
                            <div>
                                <label for="search" class="block text-sm font-medium text-gray-700 mb-1">Pencarian</label>
                                <input type="text" id="search" name="search" value="<?php echo e(request('search')); ?>" placeholder="Cari truk/jenis BBM..." class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                            </div>
                            <div>
                                <label for="start_date" class="block text-sm font-medium text-gray-700 mb-1">Tanggal Mulai</label>
                                <input type="date" id="start_date" name="start_date" value="<?php echo e(request('start_date')); ?>" class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                            </div>
                            <div>
                                <label for="end_date" class="block text-sm font-medium text-gray-700 mb-1">Tanggal Akhir</label>
                                <input type="date" id="end_date" name="end_date" value="<?php echo e(request('end_date')); ?>" class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                            </div>
                            <div>
                                <button type="submit" class="w-full bg-blue-600 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded">
                                    <i class="fas fa-filter mr-2"></i>Filter
                                </button>
                            </div>
                        </form>
                    </div>
                    <!-- Akhir Form Pencarian dan Filter -->

                    <!-- Tab Navigation -->
                    <div class="mb-4">
                        <nav class="flex space-x-8" aria-label="Tabs">
                            <button id="tabPurchases" class="tab-button active border-b-2 border-indigo-500 py-2 px-1 text-sm font-medium text-indigo-600">
                                Pembelian BBM
                            </button>
                            <button id="tabManualOps" class="tab-button border-b-2 border-transparent py-2 px-1 text-sm font-medium text-gray-500 hover:text-gray-700 hover:border-gray-300">
                                Operasi Manual Stok
                            </button>
                        </nav>
                    </div>

                    <!-- Tab Content: Pembelian BBM -->
                    <div id="contentPurchases" class="tab-content">
                        <div class="overflow-x-auto">
                            <table class="min-w-full bg-white">
                                <thead class="bg-gray-100">
                                    <tr>
                                        <th class="py-3 px-4 text-left">Tanggal</th>
                                        <th class="py-3 px-4 text-left">Truk</th>
                                        <th class="py-3 px-4 text-left">Jenis BBM</th>
                                        <th class="py-3 px-4 text-left">Jumlah (L)</th>
                                        <th class="py-3 px-4 text-left">Harga/L</th>
                                        <th class="py-3 px-4 text-left">Total</th>
                                        <th class="py-3 px-4 text-left">Aksi</th>
                                    </tr>
                                </thead>
                                <tbody class="divide-y divide-gray-200">
                                    <?php $__empty_1 = true; $__currentLoopData = $fuelPurchases; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $purchase): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <tr class="hover:bg-gray-50">
                                            <td class="py-3 px-4"><?php echo e($purchase->purchase_date->format('d/m/Y')); ?></td>
                                            <td class="py-3 px-4"><?php echo e($purchase->truck->plate_number); ?></td>
                                            <td class="py-3 px-4"><?php echo e($purchase->fuel_type); ?></td>
                                            <td class="py-3 px-4"><?php echo e(number_format($purchase->quantity, 2)); ?></td>
                                            <td class="py-3 px-4">Rp <?php echo e(number_format($purchase->price_per_liter, 0, ',', '.')); ?></td>
                                            <td class="py-3 px-4">Rp <?php echo e(number_format($purchase->total_cost, 0, ',', '.')); ?></td>
                                            <td class="py-3 px-4">
                                                <div class="flex space-x-2">
                                                    <a href="<?php echo e(route('fuel-purchases.show', $purchase)); ?>" class="text-blue-500 hover:text-blue-700">
                                                        <i class="fas fa-eye"></i>
                                                    </a>
                                                    <a href="<?php echo e(route('fuel-purchases.edit', $purchase)); ?>" class="text-yellow-500 hover:text-yellow-700">
                                                        <i class="fas fa-edit"></i>
                                                    </a>
                                                    <form action="<?php echo e(route('fuel-purchases.destroy', $purchase)); ?>" method="POST" class="inline" onsubmit="return confirm('Apakah Anda yakin ingin menghapus data ini?');">
                                                        <?php echo csrf_field(); ?>
                                                        <?php echo method_field('DELETE'); ?>
                                                        <button type="submit" class="text-red-500 hover:text-red-700">
                                                            <i class="fas fa-trash"></i>
                                                        </button>
                                                    </form>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <tr>
                                            <td colspan="7" class="py-3 px-4 text-center">Tidak ada data pembelian bahan bakar</td>
                                        </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>

                        <div class="mt-4">
                            <?php echo e($fuelPurchases->appends(request()->query())->links()); ?>

                        </div>
                    </div>

                    <!-- Tab Content: Operasi Manual Stok -->
                    <div id="contentManualOps" class="tab-content hidden">
                        <div class="overflow-x-auto">
                            <table class="min-w-full bg-white">
                                <thead class="bg-gray-100">
                                    <tr>
                                        <th class="py-3 px-4 text-left">Tanggal</th>
                                        <th class="py-3 px-4 text-left">Jenis BBM</th>
                                        <th class="py-3 px-4 text-left">Operasi</th>
                                        <th class="py-3 px-4 text-left">Jumlah (L)</th>
                                        <th class="py-3 px-4 text-left">Catatan</th>
                                        <th class="py-3 px-4 text-left">Oleh</th>
                                    </tr>
                                </thead>
                                <tbody class="divide-y divide-gray-200">
                                    <?php $__empty_1 = true; $__currentLoopData = $fuelStockLogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $log): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <tr class="hover:bg-gray-50">
                                            <td class="py-3 px-4"><?php echo e($log->operation_date->format('d/m/Y H:i')); ?></td>
                                            <td class="py-3 px-4"><?php echo e($log->fuel_type); ?></td>
                                            <td class="py-3 px-4">
                                                <?php if($log->operation_type === 'add'): ?>
                                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-green-100 text-green-800">
                                                        <i class="fas fa-plus mr-1"></i> Tambah
                                                    </span>
                                                <?php else: ?>
                                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-red-100 text-red-800">
                                                        <i class="fas fa-minus mr-1"></i> Kurangi
                                                    </span>
                                                <?php endif; ?>
                                            </td>
                                            <td class="py-3 px-4"><?php echo e(number_format($log->quantity, 2)); ?></td>
                                            <td class="py-3 px-4"><?php echo e($log->notes ?: '-'); ?></td>
                                            <td class="py-3 px-4"><?php echo e($log->user->name ?? 'System'); ?></td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <tr>
                                            <td colspan="6" class="py-3 px-4 text-center">Belum ada operasi manual stok BBM</td>
                                        </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Tombol Tambah Stok
            document.getElementById('btnAddStock').addEventListener('click', function() {
                document.getElementById('modalAddStock').classList.remove('hidden');
            });
            
            // Tombol Kurangi Stok
            document.getElementById('btnReduceStock').addEventListener('click', function() {
                document.getElementById('modalReduceStock').classList.remove('hidden');
            });
            
            // Tombol Close Modal
            document.querySelectorAll('.closeModal').forEach(function(button) {
                button.addEventListener('click', function() {
                    document.getElementById('modalAddStock').classList.add('hidden');
                    document.getElementById('modalReduceStock').classList.add('hidden');
                });
            });
        });
    </script>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // ... existing modal code ...
            
            // Tab functionality
            const tabButtons = document.querySelectorAll('.tab-button');
            const tabContents = document.querySelectorAll('.tab-content');
            
            tabButtons.forEach(button => {
                button.addEventListener('click', function() {
                    const targetId = this.id.replace('tab', 'content');
                    
                    // Remove active class from all tabs
                    tabButtons.forEach(btn => {
                        btn.classList.remove('active', 'border-indigo-500', 'text-indigo-600');
                        btn.classList.add('border-transparent', 'text-gray-500');
                    });
                    
                    // Add active class to clicked tab
                    this.classList.add('active', 'border-indigo-500', 'text-indigo-600');
                    this.classList.remove('border-transparent', 'text-gray-500');
                    
                    // Hide all tab contents
                    tabContents.forEach(content => {
                        content.classList.add('hidden');
                    });
                    
                    // Show target content
                    document.getElementById(targetId).classList.remove('hidden');
                });
            });
        });
    </script>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?><?php /**PATH D:\wamp64\www\obm\resources\views/fuel-purchases/index.blade.php ENDPATH**/ ?>