<?php $__env->startSection('content'); ?>
<div class="container mx-auto px-4 py-6">
    <div class="flex justify-between items-center mb-6">
        <h1 class="text-2xl font-bold text-gray-800">Laporan Bahan Bakar</h1>
        <div class="flex space-x-2">
            <button onclick="exportToPDF()" class="bg-red-600 hover:bg-red-700 text-white font-bold py-2 px-4 rounded">
                <i class="fas fa-file-pdf mr-2"></i>Export PDF
            </button>
            <button onclick="exportToExcel()" class="bg-green-600 hover:bg-green-700 text-white font-bold py-2 px-4 rounded">
                <i class="fas fa-file-excel mr-2"></i>Export Excel
            </button>
        </div>
    </div>

    <div class="bg-white rounded-lg shadow-md overflow-hidden p-6 mb-6">
        <h2 class="text-lg font-semibold mb-4">Filter Laporan</h2>
        <form action="<?php echo e(route('reports.fuel')); ?>" method="GET" class="w-full">
            <div class="flex flex-col lg:flex-row lg:items-end gap-4">
                <div class="flex-1">
                    <label for="start_date" class="block text-sm font-medium text-gray-700 mb-1">Tanggal Mulai</label>
                    <input type="date" id="start_date" name="start_date" value="<?php echo e($startDate); ?>" class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                </div>
                <div class="flex-1">
                    <label for="end_date" class="block text-sm font-medium text-gray-700 mb-1">Tanggal Akhir</label>
                    <input type="date" id="end_date" name="end_date" value="<?php echo e($endDate); ?>" class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                </div>
                <div class="flex-1">
                    <label for="truck_id" class="block text-sm font-medium text-gray-700 mb-1">Plat Nomor</label>
                    <select id="truck_id" name="truck_id" class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                        <?php $__currentLoopData = $trucks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $truck): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($truck->id); ?>" <?php echo e($truckId == $truck->id ? 'selected' : ''); ?>><?php echo e($truck->plate_number); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="flex-1">
                    <label for="fuel_type" class="block text-sm font-medium text-gray-700 mb-1">Tipe Bahan Bakar</label>
                    <select id="fuel_type" name="fuel_type" class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                        <option value="">Semua Tipe</option>
                        <?php $__currentLoopData = $fuelTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($type); ?>" <?php echo e($fuelType == $type ? 'selected' : ''); ?>><?php echo e($type); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

                <div class="flex items-end">
                    <button type="submit" class="bg-blue-600 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded w-full">
                        <i class="fas fa-filter mr-2"></i>Filter
                    </button>
                </div>
            </div>
        </form>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6 mb-6">
        <div class="bg-white rounded-lg shadow-md p-6">
            <h3 class="text-lg font-semibold mb-4">Pemakaian BBM per Truk</h3>
            <div id="google_fuel_truck_chart" style="width: 100%; height: 350px;"></div>
        </div>
        <div class="bg-white rounded-lg shadow-md p-6">
            <h3 class="text-lg font-semibold mb-4">Biaya BBM per Bulan</h3>
            <div id="google_fuel_month_chart" style="width: 100%; height: 350px;"></div>
        </div>
    </div>

    <div class="bg-white rounded-lg shadow-md overflow-hidden">
        <h3 class="text-lg font-semibold p-6 border-b">Daftar Pembelian Bahan Bakar</h3>
        <?php if($fuelPurchases->count() > 0): ?>
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Tanggal</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Truk</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Tipe Bahan Bakar</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Lokasi</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Volume (Liter)</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Harga Total</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">SPBU</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        <?php $__currentLoopData = $fuelPurchases; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $fuel): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500"><?php echo e($fuel->purchase_date->format('d/m/Y')); ?></td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500"><?php echo e(optional($fuel->truck)->plate_number ?? '-'); ?></td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500"><?php echo e($fuel->fuel_type); ?></td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500"><?php echo e($fuel->station_name ?? '-'); ?></td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500"><?php echo e($fuel->quantity); ?></td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">Rp <?php echo e(number_format($fuel->total_cost, 0, ',', '.')); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        <?php else: ?>
            <div class="p-6 text-center text-gray-500">
                Tidak ada data pembelian bahan bakar sesuai filter.
            </div>
        <?php endif; ?>
    </div>
</div>

<script type="text/javascript" src="https://www.gstatic.com/charts/loader.js"></script>
<script type="text/javascript">
    google.charts.load('current', {'packages':['corechart', 'bar']});
    google.charts.setOnLoadCallback(drawCharts);

    function drawCharts() {
        // Chart Fuel per Truck
        var truckArr = [
            ['Plat Nomor', 'Volume (Liter)'],
            <?php $hasTruckData = false; ?>
            <?php $__currentLoopData = $fuelByTruck; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $truckId => $volume): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php $hasTruckData = true; ?>
                [
                    '<?php echo e(optional($trucks->first(fn($t) => $t->id == $truckId))->plate_number ?? $truckId); ?>',
                    <?php echo e(is_numeric($volume) ? $volume : 0); ?>

                ]<?php if(!$loop->last): ?>,<?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php if(!$hasTruckData): ?>
                ['Tidak ada data', 0]
            <?php endif; ?>
        ];
        console.log('truckArr', truckArr);
        
        // Tambahkan kode yang hilang untuk menggambar chart truck
        var truckData = google.visualization.arrayToDataTable(truckArr);
        var truckOptions = {
            title: 'Pemakaian BBM per Truk',
            height: 350,
            colors: ['#3B82F6'],
            chartArea: {width: '70%'},
            legend: { position: 'none' },
            hAxis: {
                title: 'Volume (Liter)'
            },
            vAxis: {
                title: 'Plat Nomor'
            }
        };
        var truckChart = new google.visualization.BarChart(document.getElementById('google_fuel_truck_chart'));
        truckChart.draw(truckData, truckOptions);
        
        // Chart Fuel per Month
        var monthArr = [
            ['Bulan', 'Biaya (Rp)'],
            <?php $hasMonthData = false; ?>
            <?php $__currentLoopData = $fuelByMonth; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bulan => $cost): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php $hasMonthData = true; ?>
                ['<?php echo e($bulan); ?>', <?php echo e(is_numeric($cost) ? $cost : 0); ?>]<?php if(!$loop->last): ?>,<?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php if(!$hasMonthData): ?>
                ['Tidak ada data', 0]
            <?php endif; ?>
        ];
        console.log('monthArr', monthArr);
        var monthData = google.visualization.arrayToDataTable(monthArr);
        var monthOptions = {
            title: 'Biaya BBM per Bulan',
            height: 350,
            colors: ['#EC4899'],
            chartArea: {width: '70%'},
            legend: { position: 'none' }
        };
        var monthChart = new google.visualization.BarChart(document.getElementById('google_fuel_month_chart'));
        monthChart.draw(monthData, monthOptions);
    }

    function exportToPDF() {
        window.location.href = '<?php echo e(route("reports.fuel.export.pdf")); ?>' + window.location.search;
    }

    function exportToExcel() {
        window.location.href = '<?php echo e(route("reports.fuel.export.excel")); ?>' + window.location.search;
    }
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\wamp64\www\obm\resources\views/reports/fuel.blade.php ENDPATH**/ ?>