<?php echo $__env->make('reports.partials.platnomor_helper', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<?php $__env->startSection('content'); ?>
<div class="container mx-auto px-4 py-6">
    <div class="flex justify-between items-center mb-6">
        <h1 class="text-2xl font-bold text-gray-800">Laporan Perjalanan</h1>
        <div class="flex space-x-2">
            <button onclick="exportToPDF()" class="bg-red-600 hover:bg-red-700 text-white font-bold py-2 px-4 rounded">
                <i class="fas fa-file-pdf mr-2"></i>Export PDF
            </button>
            <button onclick="exportToExcel()" class="bg-green-600 hover:bg-green-700 text-white font-bold py-2 px-4 rounded">
                <i class="fas fa-file-excel mr-2"></i>Export Excel
            </button>
        </div>
    </div>

    <div class="bg-white rounded-lg shadow-md overflow-hidden p-6 mb-6">
        <h2 class="text-lg font-semibold mb-4">Filter Laporan</h2>
        <form action="<?php echo e(route('reports.trips')); ?>" method="GET" class="w-full">
            <div class="flex flex-col lg:flex-row lg:items-end gap-4">
                <div class="flex-1">
                    <label for="start_date" class="block text-sm font-medium text-gray-700 mb-1">Tanggal Mulai</label>
                    <input type="date" id="start_date" name="start_date" value="<?php echo e($startDate); ?>" class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                </div>
                <div class="flex-1">
                    <label for="end_date" class="block text-sm font-medium text-gray-700 mb-1">Tanggal Akhir</label>
                    <input type="date" id="end_date" name="end_date" value="<?php echo e($endDate); ?>" class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                </div>
                <div class="flex-1">
                    <label for="license_plate" class="block text-sm font-medium text-gray-700 mb-1">Plat Nomor</label>
                    <input type="text" id="license_plate" name="license_plate" value="<?php echo e($licensePlate); ?>" class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50" placeholder="Cari plat nomor...">
                </div>
                <div class="flex-1">
                    <label for="driver_id" class="block text-sm font-medium text-gray-700 mb-1">Driver</label>
                    <select id="driver_id" name="driver_id" class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                        <option value="">Semua Driver</option>
                        <?php $__currentLoopData = $drivers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $driver): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($driver->id); ?>" <?php echo e($driverId == $driver->id ? 'selected' : ''); ?>><?php echo e($driver->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="flex-1">
                    <label for="project_id" class="block text-sm font-medium text-gray-700 mb-1">Proyek</label>
                    <select id="project_id" name="project_id" class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                        <option value="">Semua Proyek</option>
                        <?php $__currentLoopData = $projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $project): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($project->id); ?>" <?php echo e(isset($projectId) && $projectId == $project->id ? 'selected' : ''); ?>><?php echo e($project->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="flex items-end">
                    <button type="submit" class="bg-blue-600 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded w-full">
                        <i class="fas fa-filter mr-2"></i>Filter
                    </button>
                </div>
            </div>
        </form>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6 mb-6">
        <div class="bg-white rounded-lg shadow-md p-6">
            <h3 class="text-lg font-semibold mb-2">Total Perjalanan</h3>
            <p class="text-3xl font-bold text-blue-600"><?php echo e($trips->count()); ?></p>
        </div>
        <div class="bg-white rounded-lg shadow-md p-6">
            <h3 class="text-lg font-semibold mb-2">Total Jarak</h3>
            <p class="text-3xl font-bold text-green-600"><?php echo e(number_format($totalDistance, 0, ',', '.')); ?> km</p>
        </div>
        <div class="bg-white rounded-lg shadow-md p-6">
            <h3 class="text-lg font-semibold mb-2">Total Retase</h3>
            <p class="text-3xl font-bold text-yellow-600"><?php echo e($trips->sum(fn($trip) => $trip->driverActivities->sum('retase'))); ?></p>
        </div>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6 mb-6">
        <div class="bg-white rounded-lg shadow-md p-6">
            <h3 class="text-lg font-semibold mb-4">Retase per Driver</h3>
            <div id="retaseByDriverChart" style="width: 100%; height: 350px;"></div>
        </div>
        <div class="bg-white rounded-lg shadow-md p-6">
            <h3 class="text-lg font-semibold mb-4">Perjalanan per Proyek</h3>
            <div id="tripsByProjectChart" style="width: 100%; height: 350px;"></div>
        </div>
    </div>

    <div class="bg-white rounded-lg shadow-md overflow-hidden">
        <h3 class="text-lg font-semibold p-6 border-b">Daftar Perjalanan</h3>
        <?php if($trips->count() > 0): ?>
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Tanggal</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Truk (Plat Nomor)</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Driver</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Dari</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Tujuan</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Jarak (km)</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Retase</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Material</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        <?php $__currentLoopData = $trips; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trip): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500"><?php echo e($trip->start_date->format('d/m/Y')); ?></td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500"><?php echo e(getPlatNomor($trip)); ?></td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500"><?php echo e($trip->driver->name); ?></td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500"><?php echo e($trip->origin); ?></td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500"><?php echo e($trip->destination); ?></td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500"><?php echo e($trip->distance); ?></td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500"><?php echo e($trip->driverActivities->sum('retase')); ?></td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500"><?php echo e(optional($trip->materialNp)->name ?? '-'); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        <?php else: ?>
            <div class="p-6 text-center text-gray-500">
                Tidak ada data perjalanan yang sesuai dengan filter.
            </div>
        <?php endif; ?>
    </div>
</div>

<!-- Google Charts loader -->
<script type="text/javascript" src="https://www.gstatic.com/charts/loader.js"></script>
<script type="text/javascript">
    google.charts.load('current', {'packages':['corechart', 'bar']});
    google.charts.setOnLoadCallback(drawCharts);

    function drawCharts() {
        // Data Retase per Driver (Bar Chart)
        var driverRetase = [
            ['Driver', 'Jumlah Retase'],
            <?php
                $driverRetaseArr = $trips->groupBy('driver_id')->map(function($trips, $driverId) {
                    $driver = $trips->first()->driver;
                    $totalRetase = $trips->sum(fn($t) => $t->driverActivities->sum('retase'));
                    return [
                        'name' => $driver ? $driver->name : 'Unknown',
                        'retase' => $totalRetase
                    ];
                })->sortByDesc('retase');
            ?>
            <?php $__currentLoopData = $driverRetaseArr; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                ['<?php echo e($item['name']); ?>', <?php echo e($item['retase']); ?>],
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        ];
        var driverData = google.visualization.arrayToDataTable(driverRetase);
        var driverOptions = {
            title: 'Retase per Driver',
            legend: { position: 'none' },
            colors: ['#F59E0B'],
            chartArea: {width: '70%'},
            hAxis: { minValue: 0, format: '0' },
        };
        var driverChart = new google.visualization.BarChart(document.getElementById('retaseByDriverChart'));
        driverChart.draw(driverData, driverOptions);

        // Data Perjalanan per Proyek (Pie Chart)
        var projectData = google.visualization.arrayToDataTable([
            ['Proyek', 'Jumlah Perjalanan'],
            <?php $__currentLoopData = $tripsByProject; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $projectId => $count): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                [
                    '<?php echo e(optional($projects->first(fn($p) => $p->id == $projectId))->name ?? $projectId); ?>',
                    <?php echo e($count); ?>

                ],
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        ]);
        var projectOptions = {
            title: 'Perjalanan per Proyek',
            pieHole: 0.4,
            legend: { position: 'right' },
            chartArea: {width: '80%', height: '80%'},
        };
        var projectChart = new google.visualization.PieChart(document.getElementById('tripsByProjectChart'));
        projectChart.draw(projectData, projectOptions);
    }

    // Fungsi untuk export ke PDF
    function exportToPDF() {
        window.location.href = '<?php echo e(route("reports.trips.export.pdf")); ?>' + window.location.search;
    }
    // Fungsi untuk export ke Excel
    function exportToExcel() {
        window.location.href = '<?php echo e(route("reports.trips.export.excel")); ?>' + window.location.search;
    }
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\wamp64\www\obm\resources\views/reports/trips.blade.php ENDPATH**/ ?>