

<?php $__env->startSection('content'); ?>
<div class="container mx-auto px-4 py-6">
    <div class="flex justify-between items-center mb-6">
        <h1 class="text-2xl font-bold text-gray-800">Laporan Pengeluaran</h1>
        <div class="flex space-x-2">
            <button id="exportPdfBtn" class="bg-red-600 hover:bg-red-700 text-white font-bold py-2 px-4 rounded">
                <i class="fas fa-file-pdf mr-2"></i>Export PDF
            </button>
            <button id="exportExcelBtn" class="bg-green-600 hover:bg-green-700 text-white font-bold py-2 px-4 rounded">
                <i class="fas fa-file-excel mr-2"></i>Export Excel
            </button>
        </div>
    </div>

    <div class="bg-white rounded-lg shadow-md overflow-hidden p-6 mb-6">
        <h2 class="text-lg font-semibold mb-4">Filter Laporan</h2>
        <form id="filterForm" action="<?php echo e(route('reports.expenses')); ?>" method="GET" class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-5 gap-4">
            <div>
                <label for="start_date" class="block text-sm font-medium text-gray-700 mb-1">Tanggal Mulai</label>
                <input type="date" id="start_date" name="start_date" value="<?php echo e($startDate); ?>" class="w-full rounded-md border-gray-300 shadow-sm">
            </div>
            <div>
                <label for="end_date" class="block text-sm font-medium text-gray-700 mb-1">Tanggal Akhir</label>
                <input type="date" id="end_date" name="end_date" value="<?php echo e($endDate); ?>" class="w-full rounded-md border-gray-300 shadow-sm">
            </div>
            <div>
                <label for="project_id" class="block text-sm font-medium text-gray-700 mb-1">Proyek</label>
                <select id="project_id" name="project_id" class="w-full rounded-md border-gray-300 shadow-sm">
                    <option value="">Semua Proyek</option>
                    <?php $__currentLoopData = $projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $project): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($project->id); ?>" <?php echo e($projectId == $project->id ? 'selected' : ''); ?>><?php echo e($project->name); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div>
                <label for="category" class="block text-sm font-medium text-gray-700 mb-1">Kategori</label>
                <select id="category" name="category" class="w-full rounded-md border-gray-300 shadow-sm">
                    <option value="">Semua Kategori</option>
                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($cat); ?>" <?php echo e($category == $cat ? 'selected' : ''); ?>><?php echo e($cat); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div>
                <label for="status" class="block text-sm font-medium text-gray-700 mb-1">Status</label>
                <select id="status" name="status" class="w-full rounded-md border-gray-300 shadow-sm">
                    <option value="">Semua Status</option>
                    <?php $__currentLoopData = $statuses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $stat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($stat); ?>" <?php echo e($status == $stat ? 'selected' : ''); ?>>
                            <?php if($stat == 'draft'): ?>
                                Draft
                            <?php elseif($stat == 'approved'): ?>
                                Disetujui
                            <?php elseif($stat == 'rejected'): ?>
                                Ditolak
                            <?php endif; ?>
                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="lg:col-span-5 flex justify-end">
                <button type="submit" class="bg-blue-600 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded">
                    <i class="fas fa-filter mr-2"></i>Filter
                </button>
            </div>
        </form>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6 mb-6">
        <div class="bg-white rounded-lg shadow-md p-6">
            <h3 class="text-lg font-semibold mb-2">Total Pengeluaran</h3>
            <p class="text-3xl font-bold text-red-600">Rp <?php echo e(number_format($totalExpenses, 0, ',', '.')); ?></p>
        </div>
        <div class="bg-white rounded-lg shadow-md p-6">
            <h3 class="text-lg font-semibold mb-2">Jumlah Transaksi</h3>
            <p class="text-3xl font-bold text-blue-600"><?php echo e($expenses->count()); ?></p>
        </div>
        <div class="bg-white rounded-lg shadow-md p-6">
            <h3 class="text-lg font-semibold mb-2">Rata-rata Pengeluaran</h3>
            <p class="text-3xl font-bold text-green-600">
                <?php if($expenses->count() > 0): ?>
                    Rp <?php echo e(number_format($totalExpenses / $expenses->count(), 0, ',', '.')); ?>

                <?php else: ?>
                    Rp 0
                <?php endif; ?>
            </p>
        </div>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6 mb-6">
        <div class="bg-white rounded-lg shadow-md p-6">
            <h3 class="text-lg font-semibold mb-4">Pengeluaran per Kategori</h3>
            <div id="google_expenses_category_chart" style="width: 100%; height: 350px;"></div>
        </div>
        <div class="bg-white rounded-lg shadow-md p-6">
            <h3 class="text-lg font-semibold mb-4">Pengeluaran per Status</h3>
            <div id="google_expenses_status_chart" style="width: 100%; height: 350px;"></div>
        </div>
    </div>

    <div class="bg-white rounded-lg shadow-md overflow-hidden">
        <h3 class="text-lg font-semibold p-6 border-b">Daftar Pengeluaran</h3>
        <?php if($expenses->count() > 0): ?>
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Judul</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Jumlah</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Tanggal</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Kategori</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Proyek</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        <?php $__currentLoopData = $expenses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $expense): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900"><?php echo e($expense->title); ?></td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">Rp <?php echo e(number_format($expense->amount, 0, ',', '.')); ?></td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500"><?php echo e($expense->expense_date->format('d/m/Y')); ?></td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500"><?php echo e($expense->category); ?></td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500"><?php echo e($expense->project ? $expense->project->name : 'Tidak Ada'); ?></td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                    <?php if($expense->status == 'draft'): ?>
                                        <span class="px-2 py-1 bg-yellow-100 text-yellow-800 rounded-full text-xs">Draft</span>
                                    <?php elseif($expense->status == 'approved'): ?>
                                        <span class="px-2 py-1 bg-green-100 text-green-800 rounded-full text-xs">Disetujui</span>
                                    <?php elseif($expense->status == 'rejected'): ?>
                                        <span class="px-2 py-1 bg-red-100 text-red-800 rounded-full text-xs">Ditolak</span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        <?php else: ?>
            <div class="p-6 text-center text-gray-500">
                Tidak ada data pengeluaran yang sesuai dengan filter.
            </div>
        <?php endif; ?>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script type="text/javascript" src="https://www.gstatic.com/charts/loader.js"></script>
<script>
    google.charts.load('current', { packages: ['corechart'] });
    google.charts.setOnLoadCallback(drawExpenseCharts);

    function drawExpenseCharts() {
        // ------------------------
        // Chart Per Kategori
        // ------------------------
        var categoryData = [['Kategori', 'Jumlah (Rp)']];
        <?php $__currentLoopData = $expensesByCategory; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat => $amount): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            categoryData.push(['<?php echo e($cat); ?>', <?php echo e($amount); ?>]);
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        var catDataTable = google.visualization.arrayToDataTable(categoryData);
        var catOptions = {
            title: 'Pengeluaran per Kategori',
            pieHole: 0.4,
            height: 350,
            chartArea: { width: '85%', height: '80%' },
            legend: { position: 'right' },
            colors: ['#4F46E5', '#10B981', '#F59E0B', '#EF4444', '#8B5CF6', '#EC4899', '#06B6D4', '#84CC16', '#F97316', '#6366F1']
        };
        var catChart = new google.visualization.PieChart(document.getElementById('google_expenses_category_chart'));
        catChart.draw(catDataTable, catOptions);

        // ------------------------
        // Chart Per Status
        // ------------------------
        var statusData = [
            ['Status', 'Jumlah (Rp)'],
            ['Draft', <?php echo e($expenses->where('status', 'draft')->sum('amount')); ?>],
            ['Disetujui', <?php echo e($expenses->where('status', 'approved')->sum('amount')); ?>],
            ['Ditolak', <?php echo e($expenses->where('status', 'rejected')->sum('amount')); ?>]
        ];

        var statusDataTable = google.visualization.arrayToDataTable(statusData);
        var statusOptions = {
            title: 'Pengeluaran per Status',
            height: 350,
            chartArea: { width: '70%' },
            legend: { position: 'none' },
            colors: ['#F59E0B', '#10B981', '#EF4444'],
            vAxis: {
                format: 'currency'
            }
        };
        var statusChart = new google.visualization.ColumnChart(document.getElementById('google_expenses_status_chart'));
        statusChart.draw(statusDataTable, statusOptions);
    }

    document.getElementById('exportPdfBtn').addEventListener('click', function() {
        window.location.href = '<?php echo e(route("reports.expenses.export.pdf")); ?>' + window.location.search;
    });

    document.getElementById('exportExcelBtn').addEventListener('click', function() {
        window.location.href = '<?php echo e(route("reports.expenses.export.excel")); ?>' + window.location.search;
    });
</script>
<?php $__env->stopPush(); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\wamp64\www\obm\resources\views/reports/expenses.blade.php ENDPATH**/ ?>