<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AppLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('header', null, []); ?> 
        <div class="flex justify-between items-center">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">
                <?php echo e(__('Detail Perjalanan')); ?>

            </h2>
            <div class="flex space-x-2">
                <a href="<?php echo e(route('trips.edit', $trip)); ?>" class="bg-yellow-500 hover:bg-yellow-700 text-white font-bold py-2 px-4 rounded">
                    <i class="fas fa-edit mr-2"></i>Edit
                </a>
                <a href="<?php echo e(route('trips.index')); ?>" class="bg-gray-500 hover:bg-gray-700 text-white font-bold py-2 px-4 rounded">
                    <i class="fas fa-arrow-left mr-2"></i>Kembali
                </a>
            </div>
        </div>
     <?php $__env->endSlot(); ?>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div class="bg-gray-50 p-4 rounded-lg">
                            <h3 class="text-lg font-semibold mb-4 border-b pb-2">Informasi Perjalanan</h3>
                            
                            <div class="grid grid-cols-2 gap-4">
                                <div class="text-sm">
                                    <p class="font-medium text-gray-500">ID Perjalanan</p>
                                    <p><?php echo e($trip->id); ?></p>
                                </div>
                                
                                <div class="text-sm">
                                    <p class="font-medium text-gray-500">Status</p>
                                    <p>
                                        <?php if($trip->status == 'ongoing'): ?>
                                            <span class="px-2 py-1 text-xs rounded-full bg-blue-100 text-blue-800">Sedang Berlangsung</span>
                                        <?php elseif($trip->status == 'completed'): ?>
                                            <span class="px-2 py-1 text-xs rounded-full bg-green-100 text-green-800">Selesai</span>
                                        <?php elseif($trip->status == 'cancelled'): ?>
                                            <span class="px-2 py-1 text-xs rounded-full bg-red-100 text-red-800">Dibatalkan</span>
                                        <?php endif; ?>
                                    </p>
                                </div>
                                
                                <!-- Tambahkan kolom Asal -->
                                <div class="text-sm">
                                    <p class="font-medium text-gray-500">Asal</p>
                                    <p><?php echo e($trip->origin ?? '-'); ?></p>
                                </div>
                                
                                <!-- Tambahkan kolom Tujuan -->
                                <div class="text-sm">
                                    <p class="font-medium text-gray-500">Tujuan</p>
                                    <p><?php echo e($trip->destination ?? '-'); ?></p>
                                </div>
                                <div class="text-sm">
                                    <p class="font-medium text-gray-500">Material (dari Driver Activity)</p>
                                    <?php if($trip->driverActivities->count()): ?>
                                        <ul>
                                            <?php $__currentLoopData = $trip->driverActivities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $activity): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <li>
                                                    <?php echo e($activity->materialNp ? $activity->materialNp->name . ' (' . $activity->materialNp->unit . ')' : '-'); ?>

                                                </li>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </ul>
                                    <?php else: ?>
                                        <p>-</p>
                                    <?php endif; ?>
                                </div>
                                <div class="text-sm">
                                    <p class="font-medium text-gray-500">Material</p>
                                    <p><?php echo e($trip->materialNp ? $trip->materialNp->name . ' (' . $trip->materialNp->unit . ')' : '-'); ?></p>
                                </div>
                                
                                <div class="text-sm">
                                    <p class="font-medium text-gray-500">Tanggal Mulai</p>
                                    <p><?php echo e($trip->start_date->format('d/m/Y H:i')); ?></p>
                                </div>
                                
                                <div class="text-sm">
                                    <p class="font-medium text-gray-500">Tanggal Selesai</p>
                                    <p><?php echo e($trip->end_date ? $trip->end_date->format('d/m/Y H:i') : '-'); ?></p>
                                </div>
                                
                                <div class="text-sm">
                                    <p class="font-medium text-gray-500">Odometer Awal</p>
                                    <p><?php echo e(number_format($trip->start_odometer, 2)); ?> km</p>
                                </div>
                                
                                <div class="text-sm">
                                    <p class="font-medium text-gray-500">Odometer Akhir</p>
                                    <p><?php echo e($trip->end_odometer ? number_format($trip->end_odometer, 2) . ' km' : '-'); ?></p>
                                </div>
                                
                                <div class="text-sm">
                                    <p class="font-medium text-gray-500">Jarak Tempuh</p>
                                    <p><?php echo e($trip->distance ? number_format($trip->distance, 2) . ' km' : '-'); ?></p>
                                </div>
                                
                                <div class="text-sm">
                                    <p class="font-medium text-gray-500">Konsumsi BBM</p>
                                    <p><?php echo e($trip->fuel_consumption ? number_format($trip->fuel_consumption, 2) . ' liter' : '-'); ?></p>
                                </div>
                                
                                <div class="text-sm">
                                    <p class="font-medium text-gray-500">Indikator Solar</p>
                                    <p><?php echo e($trip->indikator_solar ? number_format($trip->indikator_solar, 2) . ' liter' : '-'); ?></p>
                                </div>
                            </div>
                        </div>
                        
                        <div class="bg-gray-50 p-4 rounded-lg">
                            <h3 class="text-lg font-semibold mb-4 border-b pb-2">Informasi Terkait</h3>
                            
                            <div class="grid grid-cols-1 gap-4">
                                <div class="text-sm">
                                    <p class="font-medium text-gray-500">Driver</p>
                                    <p><?php echo e($trip->driver->name); ?></p>
                                </div>
                                
                                <div class="text-sm">
                                    <p class="font-medium text-gray-500">Truk</p>
                                    <p><?php echo e($trip->truck->plate_number); ?> - <?php echo e($trip->truck->brand); ?> <?php echo e($trip->truck->model); ?></p>
                                </div>
                                
                                <div class="text-sm">
                                    <p class="font-medium text-gray-500">Proyek</p>
                                    <p><?php echo e($trip->project->name ?? 'Tidak ada'); ?></p>
                                </div>
                                
                                <div class="text-sm">
                                    <p class="font-medium text-gray-500">Catatan</p>
                                    <p class="whitespace-pre-line"><?php echo e($trip->notes ?? 'Tidak ada catatan'); ?></p>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="mt-6 flex justify-between">
                        <div>
                            <p class="text-sm text-gray-500">Dibuat: <?php echo e($trip->created_at->format('d/m/Y H:i')); ?></p>
                            <p class="text-sm text-gray-500">Diperbarui: <?php echo e($trip->updated_at->format('d/m/Y H:i')); ?></p>
                        </div>
                        
                        <form action="<?php echo e(route('trips.destroy', $trip)); ?>" method="POST" class="inline-block">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button type="submit" class="bg-red-500 hover:bg-red-700 text-white font-bold py-2 px-4 rounded" onclick="return confirm('Apakah Anda yakin ingin menghapus perjalanan ini?')">
                                <i class="fas fa-trash mr-2"></i>Hapus Perjalanan
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?><?php /**PATH D:\wamp64\www\obm\resources\views/trips/show.blade.php ENDPATH**/ ?>