<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AppLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('header', null, []); ?> 
        <div class="flex justify-between items-center">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">
                <?php echo e(__('Manajemen Truk')); ?>

            </h2>
            <a href="<?php echo e(route('trucks.create')); ?>" class="bg-indigo-600 hover:bg-indigo-700 text-white font-bold py-2 px-4 rounded">
                <i class="fas fa-plus mr-2"></i>Tambah Truk
            </a>
        </div>
     <?php $__env->endSlot(); ?>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900">
                    <?php if(session('success')): ?>
                        <div class="bg-green-100 border-l-4 border-green-500 text-green-700 p-4 mb-4" role="alert">
                            <p><?php echo e(session('success')); ?></p>
                        </div>
                    <?php endif; ?>

                    <!-- Form Pencarian -->
                    <div class="mb-4">
                        <form action="<?php echo e(route('trucks.index')); ?>" method="GET" class="flex items-center">
                            <div class="flex-grow mr-4">
                                <input type="text" name="search" value="<?php echo e(request('search')); ?>" placeholder="Cari berdasarkan plat nomor, merek, atau model..." class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                            </div>
                            <button type="submit" class="bg-blue-600 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded">
                                <i class="fas fa-search mr-2"></i>Cari
                            </button>
                        </form>
                    </div>
                    <!-- Akhir Form Pencarian -->

                    <!-- Legenda Status Driver -->
                    <div class="mb-4 flex items-center space-x-6">
                        <span class="text-sm font-medium">Status Driver:</span>
                        <div class="flex items-center">
                            <div class="w-4 h-4 bg-green-100 border border-green-600 rounded mr-2"></div>
                            <span class="text-sm">Sudah Memiliki Driver</span>
                        </div>
                        <div class="flex items-center">
                            <div class="w-4 h-4 bg-red-100 border border-red-600 rounded mr-2"></div>
                            <span class="text-sm">Belum Memiliki Driver</span>
                        </div>
                    </div>
                    <!-- Akhir Legenda -->

                    <div class="overflow-x-auto">
                        <table class="min-w-full bg-white">
                            <thead class="bg-gray-100">
                                <tr>
                                    <th class="py-3 px-4 text-left">No. Plat</th>
                                    <th class="py-3 px-4 text-left">Merek</th>
                                    <th class="py-3 px-4 text-left">Model</th>
                                    <th class="py-3 px-4 text-left">Tahun</th>
                                    <th class="py-3 px-4 text-left">Kapasitas</th>
                                    <th class="py-3 px-4 text-left">Status</th>
                                    <th class="py-3 px-4 text-left">Aksi</th>
                                </tr>
                            </thead>
                            <tbody class="divide-y divide-gray-200">
                                <?php $__empty_1 = true; $__currentLoopData = $trucks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $truck): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <?php
                                        // Cek apakah truk memiliki driver yang ter-assign
                                        $hasDriver = App\Models\Driver::where('truck_id', $truck->id)->where('status', 'aktif')->exists();
                                        $rowClass = $hasDriver ? 'bg-green-50 hover:bg-green-100' : 'bg-red-50 hover:bg-red-100';
                                    ?>
                                    <tr class="<?php echo e($rowClass); ?>">
                                        <td class="py-3 px-4"><?php echo e($truck->plate_number); ?></td>
                                        <td class="py-3 px-4"><?php echo e($truck->brand); ?></td>
                                        <td class="py-3 px-4"><?php echo e($truck->model); ?></td>
                                        <td class="py-3 px-4"><?php echo e($truck->year); ?></td>
                                        <td class="py-3 px-4"><?php echo e($truck->capacity); ?></td>
                                        <td class="py-3 px-4">
                                            <span class="px-2 py-1 rounded text-xs font-semibold
                                                <?php echo e($truck->status == 'active' ? 'bg-green-100 text-green-800' : ''); ?>

                                                <?php echo e($truck->status == 'maintenance' ? 'bg-yellow-100 text-yellow-800' : ''); ?>

                                                <?php echo e($truck->status == 'inactive' ? 'bg-red-100 text-red-800' : ''); ?>

                                            ">
                                                <?php echo e($truck->status == 'active' ? 'Aktif' : ''); ?>

                                                <?php echo e($truck->status == 'maintenance' ? 'Maintenance' : ''); ?>

                                                <?php echo e($truck->status == 'inactive' ? 'Tidak Aktif' : ''); ?>

                                            </span>
                                        </td>
                                        <td class="py-3 px-4">
                                            <div class="flex space-x-2">
                                                <a href="<?php echo e(route('trucks.show', $truck)); ?>" class="text-blue-500 hover:text-blue-700">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                <a href="<?php echo e(route('trucks.edit', $truck)); ?>" class="text-yellow-500 hover:text-yellow-700">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                <form action="<?php echo e(route('trucks.destroy', $truck)); ?>" method="POST" class="inline">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>
                                                    <button type="submit" class="text-red-500 hover:text-red-700" onclick="return confirm('Apakah Anda yakin ingin menghapus truk ini?')">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                </form>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="7" class="py-3 px-4 text-center">Tidak ada data truk</td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                    
                    <div class="mt-4">
                        <?php echo e($trucks->appends(request()->query())->links()); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?><?php /**PATH D:\wamp64\www\obm\resources\views/trucks/index.blade.php ENDPATH**/ ?>