<?php

namespace App\Http\Controllers;

use App\Models\Driver;
use App\Models\ManualTripCount;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class ManualTripCountController extends Controller
{
    /**
     * Show the form for creating a new manual trip count.
     */
    public function create(Driver $driver)
    {
        return view('manual-trip-counts.create', compact('driver'));
    }

    /**
     * Store a newly created manual trip count in storage.
     */
    public function store(Request $request, Driver $driver)
    {
        $validated = $request->validate([
            'completed_trips' => 'required|integer|min:0',
            'ongoing_trips' => 'required|integer|min:0',
            'notes' => 'nullable|string',
        ]);

        $validated['driver_id'] = $driver->id;
        $validated['added_by'] = Auth::id();

        ManualTripCount::create($validated);

        return redirect()->route('drivers.show', $driver)
            ->with('success', 'Retase manual berhasil ditambahkan.');
    }

    /**
     * Display the history of manual trip counts for a driver.
     */
    public function history(Driver $driver)
    {
        $manualTripCounts = $driver->manualTripCounts()->with('addedBy')->latest()->paginate(10);
        return view('manual-trip-counts.history', compact('driver', 'manualTripCounts'));
    }
}
