<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Income extends Model
{
    use HasFactory;
    
    protected $fillable = [
        'title',
        'description',
        'amount',
        'income_date',
        'project_id',
        'category',
        'payment_method',
        'receipt_number',
        'payment_proof',
        'approval_status',
        'approved_by',
        'approved_at',
        'added_by'
    ];
    
    protected $casts = [
        'income_date' => 'date',
        'amount' => 'decimal:2',
        'approved_at' => 'datetime'
    ];
    
    /**
     * Get the user who added this income record
     */
    public function addedBy(): BelongsTo
    {
        return $this->belongsTo(User::class, 'added_by');
    }
    
    /**
     * Get the user who approved this income record
     */
    public function approvedBy(): BelongsTo
    {
        return $this->belongsTo(User::class, 'approved_by');
    }
    
    /**
     * Get the project associated with this income
     */
    public function project(): BelongsTo
    {
        return $this->belongsTo(Project::class);
    }
}