<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Material extends Model
{
    protected $fillable = [
        'name', 'description', 'unit', 'price_per_unit', 
        'stock', 'project_id', 'notes'
    ];
    
    protected $casts = [
        'price_per_unit' => 'decimal:2',
        'stock' => 'decimal:2'
    ];
    
    /**
     * Get the project that owns the material.
     */
    public function project(): BelongsTo
    {
        return $this->belongsTo(Project::class);
    }
}
