<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Trip extends Model
{
    protected $fillable = [
        'driver_id', 'truck_id', 'project_id', 'start_date', 'end_date',
        'start_odometer', 'end_odometer', 'distance', 'fuel_consumption',
        'status', 'notes'
    ];

    protected $casts = [
        'start_date' => 'datetime',
        'end_date' => 'datetime',
    ];

    /**
     * Get the driver that owns the trip.
     */
    public function driver(): BelongsTo
    {
        return $this->belongsTo(Driver::class);
    }

    /**
     * Get the truck that was used for the trip.
     */
    public function truck(): BelongsTo
    {
        return $this->belongsTo(Truck::class);
    }

    /**
     * Get the project associated with the trip.
     */
    public function project(): BelongsTo
    {
        return $this->belongsTo(Project::class);
    }
}
