<?php

namespace App\Providers;

use Illuminate\Foundation\Support\Providers\AuthServiceProvider as ServiceProvider;
use Illuminate\Support\Facades\Gate;
use App\Models\User;

class AuthServiceProvider extends ServiceProvider
{
    /**
     * The model to policy mappings for the application.
     *
     * @var array<class-string, class-string>
     */
    protected $policies = [
        // 'App\Models\Model' => 'App\Policies\ModelPolicy',
    ];

    /**
     * Register any authentication / authorization services.
     */
    public function boot(): void
    {
        // Implicitly grant "Super Admin" role all permissions
        // This works in the app by using gate-related functions like auth()->user->can() and @can()
        Gate::before(function (User $user, $ability) {
            if ($user->isAdmin()) {
                return true;
            }
        });

        // Mendefinisikan gate untuk setiap permission
        Gate::define('view-users', function (User $user) {
            return $user->hasPermission('view-users');
        });

        Gate::define('create-users', function (User $user) {
            return $user->hasPermission('create-users');
        });

        Gate::define('edit-users', function (User $user) {
            return $user->hasPermission('edit-users');
        });

        Gate::define('delete-users', function (User $user) {
            return $user->hasPermission('delete-users');
        });

        // Tambahkan gate untuk permission lainnya sesuai kebutuhan
    }
}