<?php

namespace App\Providers;

use App\Models\Setting;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\ServiceProvider;

// Pindahkan deklarasi fungsi helper ke luar namespace
if (!function_exists('setting')) {
    function setting($key, $default = null) {
        return config('settings.' . $key, $default);
    }
}

class SettingServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap services.
     */
    public function boot(): void
    {
        // Load settings into config if the settings table exists
        if (Schema::hasTable('settings')) {
            $settings = Setting::all();
            
            foreach ($settings as $setting) {
                $value = Setting::formatValue($setting->value, $setting->type);
                config(['settings.' . $setting->key => $value]);
            }
            
            // Konfigurasi email dari database
            if (Setting::get('mail_driver')) {
                config([
                    'mail.default' => Setting::get('mail_driver', 'smtp'),
                    'mail.mailers.smtp.host' => Setting::get('mail_host'),
                    'mail.mailers.smtp.port' => Setting::get('mail_port'),
                    'mail.mailers.smtp.username' => Setting::get('mail_username'),
                    'mail.mailers.smtp.password' => Setting::get('mail_password'),
                    'mail.mailers.smtp.encryption' => Setting::get('mail_encryption'),
                    'mail.from.address' => Setting::get('mail_from_address'),
                    'mail.from.name' => Setting::get('mail_from_name'),
                ]);
            }
        }
        
        // Hapus deklarasi fungsi helper dari sini
    }
}
