<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use App\Models\Driver;

class DriverFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = Driver::class;

    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        $statuses = ['aktif', 'cuti', 'tidak aktif'];
        $bloodTypes = ['A+', 'A-', 'B+', 'B-', 'AB+', 'AB-', 'O+', 'O-'];
        
        $joinDate = fake()->dateTimeBetween('-5 years', '-1 month');
        $exitDate = null;
        
        $status = fake()->randomElement($statuses);
        if ($status === 'tidak aktif') {
            $exitDate = fake()->dateTimeBetween($joinDate, 'now');
        }
        
        return [
            'name' => fake()->name(),
            'id_number' => fake()->unique()->numerify('##############'),
            'license_number' => fake()->unique()->numerify('######'),
            'license_expiry' => fake()->dateTimeBetween('+1 month', '+5 years'),
            'phone' => fake()->phoneNumber(),
            'address' => fake()->address(),
            'status' => $status,
            'join_date' => $joinDate,
            'exit_date' => $exitDate,
            'notes' => fake()->optional(0.7)->paragraph(),
            'emergency_contact' => fake()->phoneNumber(),
            'blood_type' => fake()->randomElement($bloodTypes),
            'profile_photo' => null, // Bisa diisi dengan path default jika ada
            'salary' => fake()->numberBetween(3000000, 8000000),
            'truck_id' => null, // Akan diisi di seeder
        ];
    }
}