<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use App\Models\Truck;

class TruckFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = Truck::class;

    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        $brands = ['Hino', 'Mitsubishi', 'Isuzu', 'Mercedes-Benz', 'Volvo', 'Scania', 'MAN', 'DAF'];
        $models = ['Ranger', 'Fuso', 'Giga', 'Actros', 'FH16', 'R450', 'TGX', 'XF'];
        $fuelTypes = ['Solar', 'Biodiesel', 'Pertamina Dex'];
        $statuses = ['active', 'maintenance', 'inactive'];
        
        return [
            'plate_number' => strtoupper(fake()->randomLetter() . fake()->randomNumber(4) . fake()->randomLetter() . fake()->randomLetter()),
            'brand' => fake()->randomElement($brands),
            'model' => fake()->randomElement($models),
            'year' => fake()->numberBetween(2015, 2023),
            'capacity' => fake()->numberBetween(5, 30) . ' ton',
            'fuel_type' => fake()->randomElement($fuelTypes),
            'status' => fake()->randomElement($statuses),
            'purchase_date' => fake()->dateTimeBetween('-5 years', 'now'),
            'last_service_date' => fake()->dateTimeBetween('-6 months', 'now'),
            'next_service_date' => fake()->dateTimeBetween('now', '+6 months'),
            'stnk_number' => fake()->numerify('##########'),
            'stnk_expire_date' => fake()->dateTimeBetween('now', '+2 years'),
            'kir_number' => fake()->numerify('KIR-####-####'),
            'kir_expire_date' => fake()->dateTimeBetween('now', '+1 year'),
            'notes' => fake()->optional(0.7)->paragraph(),
        ];
    }
}
