<?php

namespace Database\Seeders;

use App\Models\User;
use App\Models\Role;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;

class AdminSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Check if admin already exists
        if (!User::where('email', 'admin@obm.com')->exists()) {
            $user = User::create([
                'name' => 'Administrator',
                'email' => 'admin@obm.com',
                'email_verified_at' => now(),
                'password' => Hash::make('password'),
                'remember_token' => Str::random(10),
                'is_admin' => true,
            ]);

            // Assign admin role
            $adminRole = Role::where('slug', 'admin')->first();
            if ($adminRole) {
                $user->assignRole('admin');
            }
        }
    }
}
