<?php

namespace Database\Seeders;

use App\Models\Client;
use Illuminate\Database\Seeder;

class ClientSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Buat beberapa klien dengan data spesifik
        Client::create([
            'name' => 'PT Pembangunan Jaya',
            'contact_person' => 'Ahmad Sulaiman',
            'email' => 'ahmad@pembangunan-jaya.com',
            'phone' => '021-5551234',
            'address' => 'Jl. Gatot Subroto No. 123, Jakarta Selatan',
            'city' => 'Jakarta Selatan',
            'notes' => 'Klien utama untuk proyek infrastruktur',
        ]);

        Client::create([
            'name' => 'PT Karya Mandiri',
            'contact_person' => 'Budi Santoso',
            'email' => 'budi@karyamandiri.co.id',
            'phone' => '021-5552345',
            'address' => 'Jl. Sudirman No. 45, Jakarta Pusat',
            'city' => 'Jakarta Pusat',
            'notes' => 'Klien untuk proyek perumahan',
        ]);

        Client::create([
            'name' => 'PT Maju Bersama',
            'contact_person' => 'Siti Rahayu',
            'email' => 'siti@majubersama.com',
            'phone' => '021-5553456',
            'address' => 'Jl. Thamrin No. 67, Jakarta Pusat',
            'city' => 'Jakarta Pusat',
            'notes' => 'Klien untuk proyek komersial',
        ]);

        // Buat 7 klien tambahan dengan data acak
        for ($i = 0; $i < 7; $i++) {
            Client::create([
                'name' => 'PT ' . fake()->company(),
                'contact_person' => fake()->name(),
                'email' => fake()->companyEmail(),
                'phone' => fake()->phoneNumber(),
                'address' => fake()->address(),
                'city' => fake()->city(),
                'notes' => fake()->optional(0.7)->paragraph(),
            ]);
        }
    }
}