<?php

namespace Database\Seeders;

use App\Models\Expense;
use App\Models\Project;
use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Carbon;

class ExpenseSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Dapatkan semua ID project yang tersedia
        $projectIds = Project::pluck('id')->toArray();
        
        // Dapatkan ID admin untuk added_by
        $adminId = User::where('email', 'admin@obm.com')->first()->id ?? 1;
        
        // Kategori pengeluaran yang tersedia
        $categories = ['Bahan Bakar', 'Perawatan', 'Gaji', 'Administrasi', 'Lainnya'];
        
        // Metode pembayaran yang tersedia
        $paymentMethods = ['Tunai', 'Transfer Bank', 'Kartu Kredit', 'Lainnya'];
        
        // Buat 30 data pengeluaran acak
        for ($i = 0; $i < 30; $i++) {
            // Pilih project secara acak (atau null untuk pengeluaran tanpa project)
            $projectId = rand(0, 1) ? $projectIds[array_rand($projectIds)] : null;
            
            // Hitung tanggal pengeluaran (dalam 6 bulan terakhir)
            $expenseDate = Carbon::now()->subDays(rand(1, 180));
            
            // Buat data pengeluaran
            Expense::create([
                'title' => 'Pengeluaran ' . fake()->words(3, true),
                'description' => fake()->optional(0.7)->paragraph(),
                'amount' => rand(50000, 10000000) + (rand(0, 99) / 100), // Rp 50.000 - Rp 10.000.000
                'expense_date' => $expenseDate,
                'project_id' => $projectId,
                'category' => $categories[array_rand($categories)],
                'payment_method' => $paymentMethods[array_rand($paymentMethods)],
                'receipt_number' => fake()->optional(0.8)->bothify('INV-####-????'),
                'added_by' => $adminId,
            ]);
        }
        
        // Tambahkan beberapa data spesifik
        Expense::create([
            'title' => 'Pembelian Suku Cadang Truk',
            'description' => 'Pembelian suku cadang untuk perbaikan truk yang rusak',
            'amount' => 2500000.00,
            'expense_date' => Carbon::now()->subDays(5),
            'project_id' => $projectIds[0],
            'category' => 'Perawatan',
            'payment_method' => 'Transfer Bank',
            'receipt_number' => 'INV-2023-0123',
            'added_by' => $adminId,
        ]);
        
        Expense::create([
            'title' => 'Pembayaran Gaji Supir',
            'description' => 'Pembayaran gaji bulanan untuk supir',
            'amount' => 5000000.00,
            'expense_date' => Carbon::now()->subDays(2),
            'project_id' => null,
            'category' => 'Gaji',
            'payment_method' => 'Tunai',
            'receipt_number' => 'PAY-2023-0456',
            'added_by' => $adminId,
        ]);
        
        Expense::create([
            'title' => 'Biaya Administrasi Kantor',
            'description' => 'Pembayaran biaya administrasi kantor bulanan',
            'amount' => 1500000.00,
            'expense_date' => Carbon::now()->subDays(1),
            'project_id' => null,
            'category' => 'Administrasi',
            'payment_method' => 'Kartu Kredit',
            'receipt_number' => 'ADM-2023-0789',
            'added_by' => $adminId,
        ]);
    }
}