<?php

namespace Database\Seeders;

use App\Models\Truck;
use App\Models\FuelPurchase;
use Illuminate\Database\Seeder;
use Illuminate\Support\Carbon;

class FuelPurchaseSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Dapatkan semua ID truk yang tersedia
        $truckIds = Truck::pluck('id')->toArray();
        
        // Jenis bahan bakar yang tersedia
        $fuelTypes = ['Solar', 'Biodiesel', 'Pertamax', 'Pertalite', 'Dexlite'];
        
        // Nama SPBU
        $stationNames = [
            'SPBU Pertamina 34.15101', 
            'SPBU Shell Gatot Subroto', 
            'SPBU Pertamina 31.10203', 
            'SPBU Total Kuningan',
            'SPBU Pertamina 34.17701'
        ];
        
        // Buat 50 data pembelian bahan bakar
        for ($i = 0; $i < 50; $i++) {
            // Pilih truk secara acak
            $truckId = $truckIds[array_rand($truckIds)];
            
            // Dapatkan informasi truk
            $truck = Truck::find($truckId);
            
            // Tentukan jenis bahan bakar berdasarkan truk atau acak jika tidak ada
            $fuelType = $truck->fuel_type ?? $fuelTypes[array_rand($fuelTypes)];
            
            // Hitung tanggal pembelian (dalam 6 bulan terakhir)
            $purchaseDate = Carbon::now()->subDays(rand(1, 180));
            
            // Hitung jumlah dan biaya
            $quantity = rand(50, 200) + (rand(0, 100) / 100); // 50-200 liter dengan desimal
            $pricePerLiter = rand(6000, 15000) + (rand(0, 100) / 100); // Rp 6.000 - Rp 15.000 per liter
            $totalCost = $quantity * $pricePerLiter;
            
            // Buat data pembelian bahan bakar
            FuelPurchase::create([
                'truck_id' => $truckId,
                'purchase_date' => $purchaseDate,
                'quantity' => $quantity,
                'price_per_liter' => $pricePerLiter,
                'total_cost' => $totalCost,
                'fuel_type' => $fuelType,
                'station_name' => $stationNames[array_rand($stationNames)],
                'receipt_number' => 'RCP-' . date('Ymd', strtotime($purchaseDate)) . '-' . rand(1000, 9999),
                'driver_name' => 'Driver ' . rand(1, 10), // Idealnya mengambil dari tabel driver
                'notes' => rand(0, 1) ? 'Pengisian rutin' : 'Pengisian tambahan untuk perjalanan jauh',
            ]);
        }
        
        // Tambahkan beberapa data spesifik
        FuelPurchase::create([
            'truck_id' => $truckIds[0],
            'purchase_date' => Carbon::now()->subDays(2),
            'quantity' => 120.50,
            'price_per_liter' => 6700.00,
            'total_cost' => 807350.00,
            'fuel_type' => 'Solar',
            'station_name' => 'SPBU Pertamina 34.15101',
            'receipt_number' => 'RCP-' . date('Ymd', strtotime(Carbon::now()->subDays(2))) . '-1234',
            'driver_name' => 'Budi Santoso',
            'notes' => 'Pengisian untuk perjalanan ke Bandung',
        ]);
        
        FuelPurchase::create([
            'truck_id' => $truckIds[1],
            'purchase_date' => Carbon::now()->subDays(1),
            'quantity' => 85.75,
            'price_per_liter' => 14500.00,
            'total_cost' => 1243375.00,
            'fuel_type' => 'Pertamax',
            'station_name' => 'SPBU Shell Gatot Subroto',
            'receipt_number' => 'RCP-' . date('Ymd', strtotime(Carbon::now()->subDays(1))) . '-5678',
            'driver_name' => 'Ahmad Rizki',
            'notes' => 'Pengisian untuk perjalanan ke Surabaya',
        ]);
    }
}