<?php

namespace Database\Seeders;

use App\Models\Project;
use App\Models\Client;
use Illuminate\Database\Seeder;

class ProjectSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Dapatkan semua klien
        $clients = Client::pluck('id')->toArray();
        
        // Buat beberapa proyek dengan data spesifik
        Project::create([
            'name' => 'Pembangunan Jalan Tol Cikampek-Purwakarta',
            'client_id' => Client::where('name', 'PT Pembangunan Jaya')->first()->id ?? $clients[0],
            'description' => 'Proyek pembangunan jalan tol sepanjang 45 km',
            'location' => 'Cikampek - Purwakarta',
            'start_date' => '2023-01-15',
            'end_date' => '2024-06-30',
            'status' => 'active',
            'budget' => 9999999999.99, // Nilai maksimum untuk decimal(12,2)
        ]);

        Project::create([
            'name' => 'Perumahan Green Valley',
            'client_id' => Client::where('name', 'PT Karya Mandiri')->first()->id ?? $clients[1],
            'description' => 'Pembangunan kompleks perumahan dengan 150 unit rumah',
            'location' => 'Bogor, Jawa Barat',
            'start_date' => '2023-03-10',
            'end_date' => '2024-12-31',
            'status' => 'active',
            'budget' => 2000000000.00,
        ]);

        Project::create([
            'name' => 'Mall Central Park',
            'client_id' => Client::where('name', 'PT Maju Bersama')->first()->id ?? $clients[2],
            'description' => 'Pembangunan pusat perbelanjaan 5 lantai',
            'location' => 'Jakarta Barat',
            'start_date' => '2022-11-05',
            'end_date' => '2024-05-30',
            'status' => 'active',
            'budget' => 3500000000.00,
        ]);

        // Status proyek yang mungkin
        $statuses = ['active', 'completed', 'cancelled'];
        
        // Buat 7 proyek tambahan dengan data acak
        for ($i = 0; $i < 7; $i++) {
            $startDate = fake()->dateTimeBetween('-2 years', 'now');
            $endDate = fake()->optional(0.8)->dateTimeBetween($startDate, '+2 years');
            
            Project::create([
                'name' => fake()->sentence(3),
                'client_id' => fake()->randomElement($clients),
                'description' => fake()->paragraph(),
                'location' => fake()->city() . ', ' . fake()->state(),
                'start_date' => $startDate,
                'end_date' => $endDate,
                'status' => fake()->randomElement($statuses),
                'budget' => fake()->optional(0.9)->numberBetween(50000000, 9999999999.99),
            ]);
        }
    }
}