@props(['type' => 'info', 'dismissible' => false])

@php
    $alertClass = 'alert alert-' . $type;
    if ($dismissible) {
        $alertClass .= ' alert-dismissible';
    }
@endphp

<div {{ $attributes->merge(['class' => $alertClass]) }}>
    @if($dismissible)
    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
        <span aria-hidden="true">&times;</span>
    </button>
    @endif
    
    @if(isset($slot))
        {{ $slot }}
    @endif
</div>