@props(['title' => null, 'footer' => null])

<div {{ $attributes->merge(['class' => 'card']) }}>
    @if($title)
    <div class="card-header">
        <h5 class="card-title">{{ $title }}</h5>
        @if(isset($headerActions))
            <div class="card-actions">
                {{ $headerActions }}
            </div>
        @endif
    </div>
    @endif
    
    <div class="card-body">
        {{ $slot }}
    </div>
    
    @if($footer)
    <div class="card-footer">
        {{ $footer }}
    </div>
    @endif
</div>