<x-app-layout>
    <x-slot name="header">
        <div class="flex justify-between items-center">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">
                {{ __('Manajemen Driver') }}
            </h2>
            <a href="{{ route('drivers.create') }}" class="bg-indigo-600 hover:bg-indigo-700 text-white font-bold py-2 px-4 rounded">
                <i class="fas fa-plus mr-2"></i>Tambah Driver
            </a>
        </div>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900">
                    @if (session('success'))
                        <div class="bg-green-100 border-l-4 border-green-500 text-green-700 p-4 mb-4" role="alert">
                            <p>{{ session('success') }}</p>
                        </div>
                    @endif

                    <div class="overflow-x-auto">
                        <table class="min-w-full bg-white">
                            <thead class="bg-gray-100">
                                <tr>
                                    <th class="py-3 px-4 text-left">Nama</th>
                                    <th class="py-3 px-4 text-left">No. KTP</th>
                                    <th class="py-3 px-4 text-left">No. SIM</th>
                                    <th class="py-3 px-4 text-left">Telepon</th>
                                    <th class="py-3 px-4 text-left">Status</th>
                                    <th class="py-3 px-4 text-left">Retase</th>
                                    <th class="py-3 px-4 text-left">Aksi</th>
                                </tr>
                            </thead>
                            <tbody class="divide-y divide-gray-200">
                                @forelse ($drivers as $driver)
                                    <tr class="hover:bg-gray-50">
                                        <td class="py-3 px-4">{{ $driver->name }}</td>
                                        <td class="py-3 px-4">{{ $driver->id_number }}</td>
                                        <td class="py-3 px-4">{{ $driver->license_number }}</td>
                                        <td class="py-3 px-4">{{ $driver->phone }}</td>
                                        <td class="py-3 px-4">
                                            <span class="px-2 py-1 rounded text-xs font-semibold
                                                {{ $driver->status == 'aktif' ? 'bg-green-100 text-green-800' : '' }}
                                                {{ $driver->status == 'cuti' ? 'bg-yellow-100 text-yellow-800' : '' }}
                                                {{ $driver->status == 'tidak aktif' ? 'bg-red-100 text-red-800' : '' }}
                                            ">
                                                {{ ucfirst($driver->status) }}
                                            </span>
                                        </td>
                                        <td class="py-3 px-4">
                                            <span class="px-2 py-1 rounded text-xs font-semibold bg-blue-100 text-blue-800">
                                                {{ $driver->tripCount() }}
                                            </span>
                                        </td>
                                        <td class="py-3 px-4">
                                            <div class="flex space-x-2">
                                                <a href="{{ route('drivers.show', $driver) }}" class="text-blue-500 hover:text-blue-700">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                <a href="{{ route('drivers.edit', $driver) }}" class="text-yellow-500 hover:text-yellow-700">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                <form action="{{ route('drivers.destroy', $driver) }}" method="POST" class="inline" onsubmit="return confirm('Apakah Anda yakin ingin menghapus driver ini?');">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="text-red-500 hover:text-red-700">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                </form>
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="6" class="py-3 px-4 text-center">Tidak ada data driver</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <div class="mt-4">
                        {{ $drivers->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>