<x-app-layout>
    <x-slot name="header">
        <div class="flex justify-between items-center">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">
                {{ __('Detail Driver') }}
            </h2>
            <div class="flex space-x-2">
                <a href="{{ route('drivers.edit', $driver) }}" class="bg-yellow-500 hover:bg-yellow-700 text-white font-bold py-2 px-4 rounded">
                    <i class="fas fa-edit mr-2"></i>Edit
                </a>
                <a href="{{ route('drivers.index') }}" class="bg-gray-500 hover:bg-gray-700 text-white font-bold py-2 px-4 rounded">
                    <i class="fas fa-arrow-left mr-2"></i>Kembali
                </a>
            </div>
        </div>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900">
                    <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                        <!-- Foto Profil -->
                        <div class="md:col-span-1">
                            <div class="bg-gray-100 p-4 rounded-lg">
                                @if($driver->profile_photo)
                                    <img src="{{ Storage::url($driver->profile_photo) }}" alt="{{ $driver->name }}" class="w-full h-auto rounded">
                                @else
                                    <div class="w-full h-64 flex items-center justify-center bg-gray-200 rounded">
                                        <i class="fas fa-user text-6xl text-gray-400"></i>
                                    </div>
                                @endif
                                
                                <div class="mt-4 text-center">
                                    <h3 class="text-xl font-semibold">{{ $driver->name }}</h3>
                                    <p class="text-gray-600">
                                        <span class="px-2 py-1 rounded text-xs font-semibold mt-2 inline-block
                                            {{ $driver->status == 'aktif' ? 'bg-green-100 text-green-800' : '' }}
                                            {{ $driver->status == 'cuti' ? 'bg-yellow-100 text-yellow-800' : '' }}
                                            {{ $driver->status == 'tidak aktif' ? 'bg-red-100 text-red-800' : '' }}
                                        ">
                                            {{ ucfirst($driver->status) }}
                                        </span>
                                    </p>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Informasi Driver -->
                        <div class="md:col-span-2">
                            <h3 class="text-lg font-semibold mb-4 pb-2 border-b">Informasi Driver</h3>
                            
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                <div>
                                    <p class="text-gray-600 mb-1">Nomor KTP</p>
                                    <p class="font-medium">{{ $driver->id_number }}</p>
                                </div>
                                
                                <div>
                                    <p class="text-gray-600 mb-1">Nomor SIM</p>
                                    <p class="font-medium">{{ $driver->license_number }}</p>
                                </div>
                                
                                <div>
                                    <p class="text-gray-600 mb-1">Tanggal Kadaluarsa SIM</p>
                                    <p class="font-medium">{{ $driver->license_expiry->format('d/m/Y') }}</p>
                                </div>
                                
                                <div>
                                    <p class="text-gray-600 mb-1">Telepon</p>
                                    <p class="font-medium">{{ $driver->phone }}</p>
                                </div>
                                
                                <div>
                                    <p class="text-gray-600 mb-1">Kontak Darurat</p>
                                    <p class="font-medium">{{ $driver->emergency_contact ?? '-' }}</p>
                                </div>
                                
                                <div>
                                    <p class="text-gray-600 mb-1">Golongan Darah</p>
                                    <p class="font-medium">{{ $driver->blood_type ?? '-' }}</p>
                                </div>
                                
                                <div>
                                    <p class="text-gray-600 mb-1">Tanggal Bergabung</p>
                                    <p class="font-medium">{{ $driver->join_date->format('d/m/Y') }}</p>
                                </div>
                                
                                <div>
                                    <p class="text-gray-600 mb-1">Tanggal Keluar</p>
                                    <p class="font-medium">{{ $driver->exit_date ? $driver->exit_date->format('d/m/Y') : '-' }}</p>
                                </div>
                                
                                <div>
                                    <p class="text-gray-600 mb-1">Gaji</p>
                                    <p class="font-medium">{{ $driver->salary ? 'Rp ' . number_format($driver->salary, 0, ',', '.') : '-' }}</p>
                                </div>
                                
                                <div>
                                    <p class="text-gray-600 mb-1">Armada</p>
                                    <p class="font-medium">
                                        @if($driver->truck)
                                            {{ $driver->truck->plate_number }} - {{ $driver->truck->brand }} {{ $driver->truck->model }}
                                        @else
                                            -
                                        @endif
                                    </p>
                                </div>
                            </div>
                            
                            <div class="mt-6">
                                <p class="text-gray-600 mb-1">Alamat</p>
                                <p class="font-medium">{{ $driver->address }}</p>
                            </div>
                            
                            <div class="mt-6">
                                <p class="text-gray-600 mb-1">Catatan</p>
                                <p class="font-medium">{{ $driver->notes ?? '-' }}</p>
                            </div>
                            
                            <!-- Informasi Retase -->
                            <div class="mt-6">
                                <div class="flex justify-between items-center">
                                    <h3 class="text-lg font-semibold mb-4 pb-2 border-b">Informasi Retase</h3>
                                    <div class="flex space-x-2">
                                        @can('manage-drivers')
                                            <a href="{{ route('drivers.manual-trip-counts.create', $driver) }}" class="bg-blue-500 hover:bg-blue-700 text-white text-sm font-bold py-1 px-3 rounded">
                                                <i class="fas fa-plus mr-1"></i>Tambah Retase Manual
                                            </a>
                                            <a href="{{ route('drivers.manual-trip-counts.history', $driver) }}" class="bg-gray-500 hover:bg-gray-700 text-white text-sm font-bold py-1 px-3 rounded">
                                                <i class="fas fa-history mr-1"></i>Riwayat
                                            </a>
                                        @endcan
                                    </div>
                                    <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                                        <div class="bg-blue-50 p-4 rounded-lg text-center">
                                            <p class="text-gray-600 mb-1">Total Perjalanan</p>
                                            <p class="font-bold text-2xl text-blue-600">{{ $driver->totalTripCount() }}</p>
                                            <p class="text-xs text-gray-500">(Sistem: {{ $driver->tripCount() }})</p>
                                        </div>
                                        <div class="bg-green-50 p-4 rounded-lg text-center">
                                            <p class="text-gray-600 mb-1">Perjalanan Selesai</p>
                                            <p class="font-bold text-2xl text-green-600">{{ $driver->totalCompletedTripCount() }}</p>
                                            <p class="text-xs text-gray-500">(Sistem: {{ $driver->completedTripCount() }})</p>
                                        </div>
                                        <div class="bg-yellow-50 p-4 rounded-lg text-center">
                                            <p class="text-gray-600 mb-1">Perjalanan Berlangsung</p>
                                            <p class="font-bold text-2xl text-yellow-600">{{ $driver->totalOngoingTripCount() }}</p>
                                            <p class="text-xs text-gray-500">(Sistem: {{ $driver->ongoingTripCount() }})</p>
                                        </div>
                                    </div>
                                    @if($driver->latestManualTripCount())
                                        <div class="mt-2 text-sm text-gray-600">
                                            <p>Terakhir diperbarui manual: {{ $driver->latestManualTripCount()->created_at->format('d/m/Y H:i') }} oleh {{ $driver->latestManualTripCount()->addedBy->name }}</p>
                                        </div>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>