@extends('layouts.app')

@section('content')
<div class="container mx-auto px-4 py-6">
    <div class="flex flex-col md:flex-row justify-between items-start md:items-center mb-6 gap-4">
        <h1 class="text-2xl font-bold text-gray-800">Manajemen Pengeluaran</h1>
        <div class="flex flex-wrap gap-2">
            <a href="{{ route('expenses.export') }}" class="bg-green-600 hover:bg-green-700 text-white font-bold py-2 px-4 rounded">
                <i class="fas fa-file-excel mr-2"></i>Export Excel
            </a>
            <a href="{{ route('expenses.create') }}" class="bg-indigo-600 hover:bg-indigo-700 text-white font-bold py-2 px-4 rounded">
                <i class="fas fa-plus mr-2"></i>Tambah Pengeluaran
            </a>
        </div>
    </div>

    <!-- Form Pencarian dan Filter -->
    <div class="bg-white rounded-lg shadow-md p-4 mb-6">
        <form action="{{ route('expenses.index') }}" method="GET" class="grid grid-cols-1 md:grid-cols-4 gap-4">
            <div>
                <label for="search" class="block text-sm font-medium text-gray-700 mb-1">Pencarian</label>
                <input type="text" name="search" id="search" value="{{ request('search') }}" placeholder="Cari judul atau kategori..." class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
            </div>
            <div>
                <label for="start_date" class="block text-sm font-medium text-gray-700 mb-1">Tanggal Mulai</label>
                <input type="date" name="start_date" id="start_date" value="{{ request('start_date') }}" class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
            </div>
            <div>
                <label for="end_date" class="block text-sm font-medium text-gray-700 mb-1">Tanggal Akhir</label>
                <input type="date" name="end_date" id="end_date" value="{{ request('end_date') }}" class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
            </div>
            <div class="flex items-end">
                <button type="submit" class="bg-indigo-600 hover:bg-indigo-700 text-white font-medium py-2 px-4 rounded-md transition-all duration-150">
                    <i class="fas fa-search mr-2"></i>Cari
                </button>
                <a href="{{ route('expenses.index') }}" class="ml-2 bg-gray-500 hover:bg-gray-600 text-white font-medium py-2 px-4 rounded-md transition-all duration-150">
                    <i class="fas fa-redo mr-2"></i>Reset
                </a>
            </div>
        </form>
    </div>

    @include('layouts.partials.alerts')

    @if($expenses->count() > 0)
        <!-- Tampilan tabel hanya untuk layar besar -->
        <div class="hidden lg:block bg-white rounded-lg shadow-md overflow-hidden">
            <div class="overflow-x-auto">
                <table class="w-full divide-y divide-gray-200">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Judul</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Jumlah</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Tanggal</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Kategori</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Proyek</th>
                            <th class="py-3 px-4 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Aksi</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        @foreach($expenses as $expense)
                            <tr>
                                <td class="px-6 py-4 text-sm font-medium text-gray-900">{{ $expense->title }}</td>
                                <td class="px-6 py-4 text-sm text-gray-500">Rp {{ number_format($expense->amount, 0, ',', '.') }}</td>
                                <td class="px-6 py-4 text-sm text-gray-500">{{ $expense->expense_date->format('d/m/Y') }}</td>
                                <td class="px-6 py-4 text-sm text-gray-500">{{ $expense->category }}</td>
                                <td class="px-6 py-4 text-sm text-gray-500">{{ $expense->project ? $expense->project->name : 'Tidak Ada' }}</td>
                                <td class="py-3 px-4">
                                    @if($expense->status == 'draft')
                                        <span class="px-2 py-1 bg-yellow-100 text-yellow-800 rounded-full text-xs">Draft</span>
                                    @elseif($expense->status == 'approved')
                                        <span class="px-2 py-1 bg-green-100 text-green-800 rounded-full text-xs">Disetujui</span>
                                    @elseif($expense->status == 'rejected')
                                        <span class="px-2 py-1 bg-red-100 text-red-800 rounded-full text-xs">Ditolak</span>
                                    @endif
                                </td>
                                <td class="px-6 py-4 text-sm font-medium">
                                    <div class="flex space-x-2">
                                        <a href="{{ route('expenses.show', $expense) }}" class="text-indigo-600 hover:text-indigo-900">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        <a href="{{ route('expenses.edit', $expense) }}" class="text-yellow-600 hover:text-yellow-900">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <form action="{{ route('expenses.destroy', $expense) }}" method="POST" class="inline" onsubmit="return confirm('Apakah Anda yakin ingin menghapus pengeluaran ini?');">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="text-red-600 hover:text-red-900">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                        
                                        <!-- Tombol approve/reject -->
                                        @if($expense->status == 'draft' && auth()->user()->hasPermission('approve-finances'))
                                            <form action="{{ route('expenses.approve', $expense) }}" method="POST" class="inline">
                                                @csrf
                                                @method('PATCH')
                                                <button type="submit" class="text-green-500 hover:text-green-700" title="Setujui">
                                                    <i class="fas fa-check"></i>
                                                </button>
                                            </form>
                                            <form action="{{ route('expenses.reject', $expense) }}" method="POST" class="inline">
                                                @csrf
                                                @method('PATCH')
                                                <button type="submit" class="text-red-500 hover:text-red-700" title="Tolak">
                                                    <i class="fas fa-times"></i>
                                                </button>
                                            </form>
                                        @endif
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>

        <!-- Tampilan card untuk layar kecil dan menengah -->
        <div class="lg:hidden grid grid-cols-1 md:grid-cols-2 gap-4">
            @foreach($expenses as $expense)
                <div class="bg-white rounded-lg shadow-md p-4">
                    <div class="flex justify-between items-center mb-2">
                        <h3 class="font-medium">{{ $expense->title }}</h3>
                        <span class="px-2 py-1 rounded-full text-xs
                            @if($expense->status == 'draft') bg-yellow-100 text-yellow-800
                            @elseif($expense->status == 'approved') bg-green-100 text-green-800
                            @elseif($expense->status == 'rejected') bg-red-100 text-red-800
                            @endif">
                            @if($expense->status == 'draft') Draft
                            @elseif($expense->status == 'approved') Disetujui
                            @elseif($expense->status == 'rejected') Ditolak
                            @endif
                        </span>
                    </div>
                    <div class="grid grid-cols-2 gap-2 text-sm mb-3">
                        <div>
                            <p class="text-gray-500">Tanggal:</p>
                            <p>{{ $expense->expense_date->format('d/m/Y') }}</p>
                        </div>
                        <div>
                            <p class="text-gray-500">Jumlah:</p>
                            <p>Rp {{ number_format($expense->amount, 0, ',', '.') }}</p>
                        </div>
                        <div>
                            <p class="text-gray-500">Kategori:</p>
                            <p>{{ $expense->category }}</p>
                        </div>
                        <div>
                            <p class="text-gray-500">Proyek:</p>
                            <p>{{ $expense->project ? $expense->project->name : 'Tidak Ada' }}</p>
                        </div>
                    </div>
                    <div class="flex justify-center space-x-3 border-t pt-3">
                        <a href="{{ route('expenses.show', $expense) }}" class="text-indigo-600 hover:text-indigo-900">
                            <i class="fas fa-eye"></i>
                        </a>
                        <a href="{{ route('expenses.edit', $expense) }}" class="text-yellow-600 hover:text-yellow-900">
                            <i class="fas fa-edit"></i>
                        </a>
                        <form action="{{ route('expenses.destroy', $expense) }}" method="POST" class="inline" onsubmit="return confirm('Apakah Anda yakin ingin menghapus pengeluaran ini?');">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="text-red-600 hover:text-red-900">
                                <i class="fas fa-trash"></i>
                            </button>
                        </form>
                        
                        <!-- Tombol approve/reject -->
                        @if($expense->status == 'draft' && auth()->user()->hasPermission('approve-finances'))
                            <form action="{{ route('expenses.approve', $expense) }}" method="POST" class="inline">
                                @csrf
                                @method('PATCH')
                                <button type="submit" class="text-green-500 hover:text-green-700" title="Setujui">
                                    <i class="fas fa-check"></i>
                                </button>
                            </form>
                            <form action="{{ route('expenses.reject', $expense) }}" method="POST" class="inline">
                                @csrf
                                @method('PATCH')
                                <button type="submit" class="text-red-500 hover:text-red-700" title="Tolak">
                                    <i class="fas fa-times"></i>
                                </button>
                            </form>
                        @endif
                    </div>
                </div>
            @endforeach
        </div>

        <div class="mt-4 px-4">
            {{ $expenses->links() }}
        </div>
    @else
        <div class="bg-white rounded-lg shadow-md p-6 text-center text-gray-500">
            Belum ada data pengeluaran. Silakan tambahkan pengeluaran baru.
        </div>
    @endif
</div>
@endsection