@extends('layouts.app')

@section('content')
<div class="container mx-auto px-4 py-6">
    <div class="flex justify-between items-center mb-6">
        <h1 class="text-2xl font-bold text-gray-800">Detail Pengeluaran</h1>
        <div class="flex space-x-2">
            <a href="{{ route('expenses.edit', $expense) }}" class="bg-yellow-600 hover:bg-yellow-700 text-white font-bold py-2 px-4 rounded">
                <i class="fas fa-edit mr-2"></i>Edit
            </a>
            <a href="{{ route('expenses.index') }}" class="bg-gray-600 hover:bg-gray-700 text-white font-bold py-2 px-4 rounded">
                <i class="fas fa-arrow-left mr-2"></i>Kembali
            </a>
        </div>
    </div>

    <div class="bg-white rounded-lg shadow-md overflow-hidden p-6">
        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <div>
                <h2 class="text-xl font-semibold mb-4">{{ $expense->title }}</h2>
                
                <div class="mb-4">
                    <p class="text-sm text-gray-500">Deskripsi:</p>
                    <p class="text-gray-800">{{ $expense->description ?? 'Tidak ada deskripsi' }}</p>
                </div>
                
                <div class="mb-4">
                    <p class="text-sm text-gray-500">Jumlah:</p>
                    <p class="text-gray-800 font-bold">Rp {{ number_format($expense->amount, 0, ',', '.') }}</p>
                </div>
                
                <div class="mb-4">
                    <p class="text-sm text-gray-500">Tanggal Pengeluaran:</p>
                    <p class="text-gray-800">{{ $expense->expense_date->format('d/m/Y') }}</p>
                </div>
                
                <div class="mb-4">
                    <p class="text-sm text-gray-500">Kategori:</p>
                    <p class="text-gray-800">{{ $expense->category }}</p>
                </div>
            </div>
            
            <div>
                <div class="mb-4">
                    <p class="text-sm text-gray-500">Proyek:</p>
                    <p class="text-gray-800">{{ $expense->project ? $expense->project->name : 'Tidak Ada Proyek' }}</p>
                </div>
                
                <div class="mb-4">
                    <p class="text-sm text-gray-500">Metode Pembayaran:</p>
                    <p class="text-gray-800">{{ $expense->payment_method }}</p>
                </div>
                
                <div class="mb-4">
                    <p class="text-sm text-gray-500">Nomor Kwitansi:</p>
                    <p class="text-gray-800">{{ $expense->receipt_number ?? 'Tidak Ada' }}</p>
                </div>
                
                <div class="mb-4">
                    <p class="text-sm text-gray-500">Ditambahkan Oleh:</p>
                    <p class="text-gray-800">{{ $expense->addedBy->name }}</p>
                </div>
                
                <div class="mb-4">
                    <p class="text-sm text-gray-500">Tanggal Dibuat:</p>
                    <p class="text-gray-800">{{ $expense->created_at->format('d/m/Y H:i') }}</p>
                </div>
                
                <div class="mb-4">
                    <p class="text-sm text-gray-500">Terakhir Diperbarui:</p>
                    <p class="text-gray-800">{{ $expense->updated_at->format('d/m/Y H:i') }}</p>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Tambahkan di bagian informasi detail -->
<div class="mb-4">
    <h3 class="text-lg font-semibold">Status:</h3>
    @if($expense->status == 'draft')
        <p class="px-2 py-1 bg-yellow-100 text-yellow-800 rounded-full text-xs inline-block">Draft</p>
    @elseif($expense->status == 'approved')
        <p class="px-2 py-1 bg-green-100 text-green-800 rounded-full text-xs inline-block">Disetujui</p>
    @elseif($expense->status == 'rejected')
        <p class="px-2 py-1 bg-red-100 text-red-800 rounded-full text-xs inline-block">Ditolak</p>
    @endif
</div>

<!-- Tambahkan informasi jika berasal dari pembelian bahan bakar -->
@if($expense->fuel_purchase)
<div class="mb-4">
    <h3 class="text-lg font-semibold">Sumber:</h3>
    <p>Pembelian Bahan Bakar - <a href="{{ route('fuel-purchases.show', $expense->fuel_purchase) }}" class="text-blue-500 hover:underline">Lihat Detail</a></p>
</div>
@endif

<!-- Tambahkan tombol approve/reject -->
@if($expense->status == 'draft' && auth()->user()->hasPermission('approve-finances'))
<div class="mt-4 flex space-x-2">
    <form action="{{ route('expenses.approve', $expense) }}" method="POST">
        @csrf
        @method('PATCH')
        <button type="submit" class="bg-green-500 hover:bg-green-600 text-white font-bold py-2 px-4 rounded">
            <i class="fas fa-check mr-2"></i>Setujui
        </button>
    </form>
    <form action="{{ route('expenses.reject', $expense) }}" method="POST">
        @csrf
        @method('PATCH')
        <button type="submit" class="bg-red-500 hover:bg-red-600 text-white font-bold py-2 px-4 rounded">
            <i class="fas fa-times mr-2"></i>Tolak
        </button>
    </form>
</div>
@endif
@endsection