<x-app-layout>
    <x-slot name="header">
        <div class="flex justify-between items-center">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">
                {{ __('Manajemen Bahan Bakar') }}
            </h2>
            <a href="{{ route('fuel-purchases.create') }}" class="bg-indigo-600 hover:bg-indigo-700 text-white font-bold py-2 px-4 rounded">
                <i class="fas fa-plus mr-2"></i>Tambah Pembelian
            </a>
        </div>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900">
                    @if (session('success'))
                        <div class="bg-green-100 border-l-4 border-green-500 text-green-700 p-4 mb-4" role="alert">
                            <p>{{ session('success') }}</p>
                        </div>
                    @endif

                    <div class="overflow-x-auto">
                        <table class="min-w-full bg-white">
                            <thead class="bg-gray-100">
                                <tr>
                                    <th class="py-3 px-4 text-left">Tanggal</th>
                                    <th class="py-3 px-4 text-left">Truk</th>
                                    <th class="py-3 px-4 text-left">Jenis BBM</th>
                                    <th class="py-3 px-4 text-left">Jumlah (L)</th>
                                    <th class="py-3 px-4 text-left">Harga/L</th>
                                    <th class="py-3 px-4 text-left">Total</th>
                                    <th class="py-3 px-4 text-left">Aksi</th>
                                </tr>
                            </thead>
                            <tbody class="divide-y divide-gray-200">
                                @forelse ($fuelPurchases as $purchase)
                                    <tr class="hover:bg-gray-50">
                                        <td class="py-3 px-4">{{ $purchase->purchase_date->format('d/m/Y') }}</td>
                                        <td class="py-3 px-4">{{ $purchase->truck->plate_number }}</td>
                                        <td class="py-3 px-4">{{ $purchase->fuel_type }}</td>
                                        <td class="py-3 px-4">{{ number_format($purchase->quantity, 2) }}</td>
                                        <td class="py-3 px-4">Rp {{ number_format($purchase->price_per_liter, 0, ',', '.') }}</td>
                                        <td class="py-3 px-4">Rp {{ number_format($purchase->total_cost, 0, ',', '.') }}</td>
                                        <td class="py-3 px-4">
                                            <div class="flex space-x-2">
                                                <a href="{{ route('fuel-purchases.show', $purchase) }}" class="text-blue-500 hover:text-blue-700">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                <a href="{{ route('fuel-purchases.edit', $purchase) }}" class="text-yellow-500 hover:text-yellow-700">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                <form action="{{ route('fuel-purchases.destroy', $purchase) }}" method="POST" class="inline" onsubmit="return confirm('Apakah Anda yakin ingin menghapus data ini?');">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="text-red-500 hover:text-red-700">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                </form>
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="7" class="py-3 px-4 text-center">Tidak ada data pembelian bahan bakar</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <div class="mt-4">
                        {{ $fuelPurchases->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>