@extends('layouts.app')

@section('content')
<div class="container mx-auto px-4 py-5">
    <div class="flex justify-between items-center mb-6">
        <h1 class="text-2xl font-bold text-gray-800">Detail Pembelian Bahan Bakar</h1>
        <div>
            <a href="{{ route('fuel-purchases.index') }}" class="bg-gray-500 hover:bg-gray-600 text-white py-2 px-4 rounded mr-2">
                <i class="fas fa-arrow-left mr-1"></i> Kembali
            </a>
            <a href="{{ route('fuel-purchases.edit', $fuelPurchase->id) }}" class="bg-blue-500 hover:bg-blue-600 text-white py-2 px-4 rounded">
                <i class="fas fa-edit mr-1"></i> Edit
            </a>
        </div>
    </div>

    <div class="bg-white rounded-lg shadow-md overflow-hidden">
        <div class="p-6">
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <h2 class="text-lg font-semibold mb-4 text-gray-700 border-b pb-2">Informasi Pembelian</h2>
                    
                    <div class="mb-4">
                        <p class="text-sm text-gray-600">Tanggal Pembelian</p>
                        <p class="font-medium">{{ date('d F Y', strtotime($fuelPurchase->purchase_date)) }}</p>
                    </div>
                    
                    <div class="mb-4">
                        <p class="text-sm text-gray-600">Jenis Bahan Bakar</p>
                        <p class="font-medium">{{ $fuelPurchase->fuel_type }}</p>
                    </div>
                    
                    <div class="mb-4">
                        <p class="text-sm text-gray-600">Jumlah (Liter)</p>
                        <p class="font-medium">{{ number_format($fuelPurchase->quantity, 2) }} L</p>
                    </div>
                    
                    <div class="mb-4">
                        <p class="text-sm text-gray-600">Harga per Liter</p>
                        <p class="font-medium">Rp {{ number_format($fuelPurchase->price_per_liter, 0, ',', '.') }}</p>
                    </div>
                    
                    <div class="mb-4">
                        <p class="text-sm text-gray-600">Total Biaya</p>
                        <p class="font-medium text-lg text-blue-600">Rp {{ number_format($fuelPurchase->total_cost, 0, ',', '.') }}</p>
                    </div>
                </div>
                
                <div>
                    <h2 class="text-lg font-semibold mb-4 text-gray-700 border-b pb-2">Detail Tambahan</h2>
                    
                    <div class="mb-4">
                        <p class="text-sm text-gray-600">Truk</p>
                        <p class="font-medium">{{ $fuelPurchase->truck->plate_number }} - {{ $fuelPurchase->truck->brand }} {{ $fuelPurchase->truck->model }}</p>
                    </div>
                    
                    <div class="mb-4">
                        <p class="text-sm text-gray-600">Nama Pengemudi</p>
                        <p class="font-medium">{{ $fuelPurchase->driver_name ?: 'Tidak ada' }}</p>
                    </div>
                    
                    <div class="mb-4">
                        <p class="text-sm text-gray-600">SPBU / Stasiun</p>
                        <p class="font-medium">{{ $fuelPurchase->station_name ?: 'Tidak ada' }}</p>
                    </div>
                    
                    <div class="mb-4">
                        <p class="text-sm text-gray-600">Nomor Kuitansi</p>
                        <p class="font-medium">{{ $fuelPurchase->receipt_number ?: 'Tidak ada' }}</p>
                    </div>
                    
                    @if($fuelPurchase->notes)
                    <div class="mb-4">
                        <p class="text-sm text-gray-600">Catatan</p>
                        <p class="font-medium">{{ $fuelPurchase->notes }}</p>
                    </div>
                    @endif
                </div>
            </div>
            
            <!-- Expense Information -->
            @if($fuelPurchase->expense)
            <div class="mt-8">
                <h2 class="text-lg font-semibold mb-4 text-gray-700 border-b pb-2">Informasi Pengeluaran</h2>
                
                <div class="bg-gray-50 p-4 rounded-lg">
                    <div class="flex justify-between items-center mb-2">
                        <span class="font-medium">Status:</span>
                        @if($fuelPurchase->expense->status == 'approved')
                            <span class="px-2 py-1 bg-green-100 text-green-800 rounded-full text-xs">Disetujui</span>
                        @elseif($fuelPurchase->expense->status == 'rejected')
                            <span class="px-2 py-1 bg-red-100 text-red-800 rounded-full text-xs">Ditolak</span>
                        @else
                            <span class="px-2 py-1 bg-yellow-100 text-yellow-800 rounded-full text-xs">Draft</span>
                        @endif
                    </div>
                    
                    <div class="grid grid-cols-1 md:grid-cols-3 gap-4 mt-4">
                        <div>
                            <p class="text-sm text-gray-600">Judul</p>
                            <p class="font-medium">{{ $fuelPurchase->expense->title }}</p>
                        </div>
                        
                        <div>
                            <p class="text-sm text-gray-600">Kategori</p>
                            <p class="font-medium">{{ $fuelPurchase->expense->category }}</p>
                        </div>
                        
                        <div>
                            <p class="text-sm text-gray-600">Metode Pembayaran</p>
                            <p class="font-medium">{{ $fuelPurchase->expense->payment_method }}</p>
                        </div>
                    </div>
                    
                    <div class="mt-4">
                        <a href="{{ route('expenses.show', $fuelPurchase->expense->id) }}" class="text-blue-500 hover:text-blue-700">
                            <i class="fas fa-external-link-alt mr-1"></i> Lihat Detail Pengeluaran
                        </a>
                    </div>
                </div>
            </div>
            @endif
        </div>
    </div>
</div>
@endsection