@extends('layouts.app')

@section('content')
<div class="container mx-auto px-4 py-6">
    <div class="flex flex-col md:flex-row justify-between items-start md:items-center mb-6 gap-4">
        <h1 class="text-2xl font-bold text-gray-800">Daftar Pendapatan</h1>
        <div class="flex flex-wrap gap-2">
            <a href="{{ route('incomes.create') }}" class="bg-indigo-600 hover:bg-indigo-700 text-white font-medium py-2 px-4 rounded-md transition-all duration-150">
                <i class="fas fa-plus mr-2"></i> Tambah Pendapatan
            </a>
            <a href="{{ route('incomes.export') }}" class="bg-green-600 hover:bg-green-700 text-white font-medium py-2 px-4 rounded-md transition-all duration-150">
                <i class="fas fa-file-excel mr-2"></i> Export Excel
            </a>
        </div>
    </div>

    <!-- Form Pencarian dan Filter -->
    <div class="bg-white rounded-lg shadow-md p-4 mb-6">
        <form action="{{ route('incomes.index') }}" method="GET" class="grid grid-cols-1 md:grid-cols-4 gap-4">
            <div>
                <label for="search" class="block text-sm font-medium text-gray-700 mb-1">Pencarian</label>
                <input type="text" name="search" id="search" value="{{ request('search') }}" placeholder="Cari judul atau kategori..." class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
            </div>
            <div>
                <label for="start_date" class="block text-sm font-medium text-gray-700 mb-1">Tanggal Mulai</label>
                <input type="date" name="start_date" id="start_date" value="{{ request('start_date') }}" class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
            </div>
            <div>
                <label for="end_date" class="block text-sm font-medium text-gray-700 mb-1">Tanggal Akhir</label>
                <input type="date" name="end_date" id="end_date" value="{{ request('end_date') }}" class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
            </div>
            <div class="flex items-end">
                <button type="submit" class="bg-indigo-600 hover:bg-indigo-700 text-white font-medium py-2 px-4 rounded-md transition-all duration-150">
                    <i class="fas fa-search mr-2"></i>Cari
                </button>
                <a href="{{ route('incomes.index') }}" class="ml-2 bg-gray-500 hover:bg-gray-600 text-white font-medium py-2 px-4 rounded-md transition-all duration-150">
                    <i class="fas fa-redo mr-2"></i>Reset
                </a>
            </div>
        </form>
    </div>

    @include('components.alert')

    <!-- Tampilan tabel hanya untuk layar besar -->
    <div class="hidden lg:block bg-white rounded-lg shadow-md overflow-hidden">
        <div class="overflow-x-auto">
            <table class="w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th scope="col" class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Judul</th>
                        <th scope="col" class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Tanggal</th>
                        <th scope="col" class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Jumlah</th>
                        <th scope="col" class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Kategori</th>
                        <th scope="col" class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Proyek</th>
                        <th scope="col" class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                        <th scope="col" class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Aksi</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @forelse ($incomes as $income)
                    <tr>
                        <td class="px-4 py-3">
                            <div class="text-sm font-medium text-gray-900">{{ $income->title }}</div>
                        </td>
                        <td class="px-4 py-3">
                            <div class="text-sm text-gray-500">{{ date('d/m/Y', strtotime($income->income_date)) }}</div>
                        </td>
                        <td class="px-4 py-3">
                            <div class="text-sm text-gray-900">Rp {{ number_format($income->amount, 0, ',', '.') }}</div>
                        </td>
                        <td class="px-4 py-3">
                            <div class="text-sm text-gray-500">{{ $income->category }}</div>
                        </td>
                        <td class="px-4 py-3">
                            <div class="text-sm text-gray-500">{{ $income->project ? $income->project->name : 'Tidak ada' }}</div>
                        </td>
                        <td class="px-4 py-3">
                            <span class="px-2 py-1 inline-flex text-xs leading-5 font-semibold rounded-full {{ $income->approval_status == 'pending' ? 'bg-yellow-100 text-yellow-800' : ($income->approval_status == 'approved' ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800') }}">
                                {{ $income->approval_status == 'pending' ? 'Menunggu' : ($income->approval_status == 'approved' ? 'Disetujui' : 'Ditolak') }}
                            </span>
                        </td>
                        <td class="px-4 py-3 text-sm font-medium">
                            <div class="flex space-x-2">
                                <a href="{{ route('incomes.show', $income) }}" class="text-indigo-600 hover:text-indigo-900"><i class="fas fa-eye"></i></a>
                                <a href="{{ route('incomes.edit', $income) }}" class="text-yellow-600 hover:text-yellow-900"><i class="fas fa-edit"></i></a>
                                <form action="{{ route('incomes.destroy', $income) }}" method="POST" class="inline">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="text-red-600 hover:text-red-900" onclick="return confirm('Apakah Anda yakin ingin menghapus pendapatan ini?')">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </form>
                                
                                <!-- Tombol approve/reject -->
                                @if($income->approval_status == 'pending' && auth()->user()->hasPermission('approve-finances'))
                                    <form action="{{ route('incomes.approve', $income) }}" method="POST" class="inline">
                                        @csrf
                                        @method('PATCH')
                                        <button type="submit" class="text-green-500 hover:text-green-700" title="Setujui">
                                            <i class="fas fa-check"></i>
                                        </button>
                                    </form>
                                    <form action="{{ route('incomes.reject', $income) }}" method="POST" class="inline">
                                        @csrf
                                        @method('PATCH')
                                        <button type="submit" class="text-red-500 hover:text-red-700" title="Tolak">
                                            <i class="fas fa-times"></i>
                                        </button>
                                    </form>
                                @endif
                            </div>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="7" class="px-4 py-3 text-center text-gray-500">Tidak ada data pendapatan</td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>

    <!-- Tampilan card untuk semua layar kecil dan menengah -->
    <div class="lg:hidden grid grid-cols-1 md:grid-cols-2 gap-4">
        @forelse ($incomes as $income)
        <div class="bg-white rounded-lg shadow-md p-4">
            <div class="flex justify-between items-center mb-2">
                <h3 class="font-medium">{{ $income->title }}</h3>
                <span class="px-2 py-1 {{ $income->approval_status == 'pending' ? 'bg-yellow-100 text-yellow-800' : ($income->approval_status == 'approved' ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800') }} rounded-full text-xs">
                    {{ $income->approval_status == 'pending' ? 'Menunggu' : ($income->approval_status == 'approved' ? 'Disetujui' : 'Ditolak') }}
                </span>
            </div>
            <div class="grid grid-cols-2 gap-2 text-sm mb-3">
                <div>
                    <p class="text-gray-500">Tanggal:</p>
                    <p>{{ date('d/m/Y', strtotime($income->income_date)) }}</p>
                </div>
                <div>
                    <p class="text-gray-500">Jumlah:</p>
                    <p>Rp {{ number_format($income->amount, 0, ',', '.') }}</p>
                </div>
                <div>
                    <p class="text-gray-500">Kategori:</p>
                    <p>{{ $income->category }}</p>
                </div>
                <div>
                    <p class="text-gray-500">Proyek:</p>
                    <p>{{ $income->project ? $income->project->name : 'Tidak ada' }}</p>
                </div>
            </div>
            <div class="flex justify-center space-x-3 border-t pt-3">
                <a href="{{ route('incomes.show', $income) }}" class="text-indigo-600 hover:text-indigo-900"><i class="fas fa-eye"></i></a>
                <a href="{{ route('incomes.edit', $income) }}" class="text-yellow-600 hover:text-yellow-900"><i class="fas fa-edit"></i></a>
                <form action="{{ route('incomes.destroy', $income) }}" method="POST" class="inline">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="text-red-600 hover:text-red-900" onclick="return confirm('Apakah Anda yakin ingin menghapus pendapatan ini?')">
                        <i class="fas fa-trash"></i>
                    </button>
                </form>
                
                <!-- Tombol approve/reject -->
                @if($income->approval_status == 'pending' && auth()->user()->hasPermission('approve-finances'))
                    <form action="{{ route('incomes.approve', $income) }}" method="POST" class="inline">
                        @csrf
                        @method('PATCH')
                        <button type="submit" class="text-green-500 hover:text-green-700" title="Setujui">
                            <i class="fas fa-check"></i>
                        </button>
                    </form>
                    <form action="{{ route('incomes.reject', $income) }}" method="POST" class="inline">
                        @csrf
                        @method('PATCH')
                        <button type="submit" class="text-red-500 hover:text-red-700" title="Tolak">
                            <i class="fas fa-times"></i>
                        </button>
                    </form>
                @endif
            </div>
        </div>
        @empty
        <div class="bg-white rounded-lg shadow-md p-4 text-center text-gray-500 md:col-span-2">Tidak ada data pendapatan</div>
        @endforelse
    </div>

    <div class="mt-4">
        {{ $incomes->links() }}
    </div>
</div>
@endsection