<nav x-data="{ open: false }" class="bg-white border-b border-gray-100 w-full">
    <!-- Primary Navigation Menu -->
    <div class="max-w-full mx-auto px-4 sm:px-6 lg:px-8">
        <div class="flex justify-between h-16">
            <!-- Marquee Announcement Section -->
            <div class="flex items-center w-full overflow-hidden">
                @php
                    $announcements = App\Models\Announcement::active()->latest()->get();
                @endphp
                
                @if($announcements->count() > 0)
                    <div class="flex items-center text-gray-600 mr-3">
                        <i class="fas fa-bullhorn text-indigo-500 mr-2"></i>
                    </div>
                    <marquee behavior="scroll" direction="left" class="text-gray-700">
                        @foreach($announcements as $announcement)
                            <span class="inline-flex items-center mr-8">
                                @if($announcement->type == 'reminder')
                                    <i class="fas fa-bullhorn text-yellow-500 mr-1"></i>
                                @elseif($announcement->type == 'alert')
                                    <i class="fas fa-exclamation-triangle text-red-500 mr-1"></i>
                                @elseif($announcement->type == 'news')
                                    <i class="fas fa-newspaper text-blue-500 mr-1"></i>
                                @elseif($announcement->type == 'event')
                                    <i class="fas fa-calendar-alt text-purple-500 mr-1"></i>
                                @elseif($announcement->type == 'info')
                                    <i class="fas fa-info-circle text-green-500 mr-1"></i>
                                @elseif($announcement->type == 'achievement')
                                    <i class="fas fa-trophy text-amber-500 mr-1"></i>
                                @else
                                    <i class="fas fa-bell text-gray-500 mr-1"></i>
                                @endif
                                <span class="font-medium">{{ $announcement->title }}:</span> 
                                <span class="ml-1">{{ $announcement->content }}</span>
                            </span>
                        @endforeach
                    </marquee>
                @else
                    <marquee behavior="scroll" direction="left" class="text-gray-700">
                        Selamat datang di OBM System - Sistem Manajemen Operasional Bisnis
                    </marquee>
                @endif
            </div>

            <!-- Settings Dropdown -->
            <div class="hidden sm:flex sm:items-center sm:ms-6">
                <x-dropdown align="right" width="48">
                    <x-slot name="trigger">
                        <button class="inline-flex items-center px-3 py-2 border border-transparent text-sm leading-4 font-medium rounded-md text-gray-500 bg-white hover:text-gray-700 focus:outline-none transition ease-in-out duration-150">
                            <div>{{ Auth::user()->name }}</div>

                            <div class="ms-1">
                                <svg class="fill-current h-4 w-4" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd" />
                                </svg>
                            </div>
                        </button>
                    </x-slot>

                    <x-slot name="content">
                        <x-dropdown-link :href="route('profile.edit')">
                            {{ __('Profile') }}
                        </x-dropdown-link>

                        <!-- Authentication -->
                        <form method="POST" action="{{ route('logout') }}">
                            @csrf

                            <x-dropdown-link :href="route('logout')"
                                    onclick="event.preventDefault();
                                                this.closest('form').submit();">
                                {{ __('Log Out') }}
                            </x-dropdown-link>
                        </form>
                    </x-slot>
                </x-dropdown>
            </div>

            <!-- Hamburger -->
            <div class="-me-2 flex items-center sm:hidden">
                <button @click="open = ! open" class="inline-flex items-center justify-center p-2 rounded-md text-gray-400 hover:text-gray-500 hover:bg-gray-100 focus:outline-none focus:bg-gray-100 focus:text-gray-500 transition duration-150 ease-in-out">
                    <svg class="h-6 w-6" stroke="currentColor" fill="none" viewBox="0 0 24 24">
                        <path :class="{'hidden': open, 'inline-flex': ! open }" class="inline-flex" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16" />
                        <path :class="{'hidden': ! open, 'inline-flex': open }" class="hidden" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                    </svg>
                </button>
            </div>
        </div>
    </div>

    <!-- Responsive Navigation Menu -->
    <!-- Tambahkan menu sidebar ke dalam navigasi responsif -->
    <div :class="{'block': open, 'hidden': ! open}" class="hidden sm:hidden">
        <!-- Tambahkan menu navigasi mobile di sini -->
        <div class="pt-2 pb-3 space-y-1">
            <x-responsive-nav-link :href="route('dashboard')" :active="request()->routeIs('dashboard')">
                {{ __('Dashboard') }}
            </x-responsive-nav-link>
            <!-- Tambahkan menu lain dari sidebar -->
            <x-responsive-nav-link :href="route('trucks.index')" :active="request()->routeIs('trucks.*')">
                {{ __('Truk') }}
            </x-responsive-nav-link>
            <!-- Menu lainnya -->
        </div>
        
        <!-- Responsive Settings Options -->
        <div class="pt-4 pb-1 border-t border-gray-200">
            <div class="px-4">
                <div class="font-medium text-base text-gray-800">{{ Auth::user()->name }}</div>
                <div class="font-medium text-sm text-gray-500">{{ Auth::user()->email }}</div>
            </div>

            <div class="mt-3 space-y-1">
                <x-responsive-nav-link :href="route('profile.edit')">
                    {{ __('Profile') }}
                </x-responsive-nav-link>

                <!-- Authentication -->
                <form method="POST" action="{{ route('logout') }}">
                    @csrf

                    <x-responsive-nav-link :href="route('logout')"
                            onclick="event.preventDefault();
                                        this.closest('form').submit();">
                        {{ __('Log Out') }}
                    </x-responsive-nav-link>
                </form>
            </div>
        </div>
    </div>
</nav>
