<!-- Hapus div wrapper luar karena sudah ditangani di app.blade.php -->
<div x-data="{ sidebarOpen: window.innerWidth >= 768 }" class="text-white w-full h-full transition-all duration-300 shadow-lg" :class="{'w-64': sidebarOpen, 'w-20': !sidebarOpen}">
    <!-- Sidebar Header -->
    <div class="flex items-center justify-between px-4 py-4 border-b border-indigo-700/50">
        <div class="flex items-center">
            <div class="shrink-0 flex items-center">
                <a href="{{ route('dashboard') }}">
                    <x-application-logo class="block h-10 w-auto fill-current text-white" />
                </a>
            </div>
            <div x-show="sidebarOpen" class="ml-3 text-lg font-bold tracking-wide">OBM System</div>
        </div>
        <button @click="sidebarOpen = !sidebarOpen" class="p-1.5 rounded-full hover:bg-white/10 focus:outline-none focus:ring-2 focus:ring-white/30 transition-all duration-150 md:block hidden">
            <svg class="h-5 w-5 text-white" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16" />
            </svg>
        </button>
    </div>

    <!-- Sidebar Menu - Tampilkan semua teks menu pada mobile -->
    <nav class="mt-5 px-3 pb-4">
        <!-- Konten sidebar yang ada tetap sama -->
        <!-- Dashboard -->
        <a href="{{ route('dashboard') }}" class="group flex items-center px-3 py-2.5 text-sm font-medium rounded-lg mb-1 transition-all duration-150 {{ request()->routeIs('dashboard') ? 'bg-white/10 text-white shadow-sm' : 'text-indigo-100 hover:bg-white/5' }}">
            <i class="fas fa-tachometer-alt w-5 text-center {{ request()->routeIs('dashboard') ? 'text-white' : 'text-indigo-300 group-hover:text-white' }}"></i>
            <span x-show="sidebarOpen" class="ml-3 transition-opacity">Dashboard</span>
        </a>

        <!-- Divider -->
        <div x-show="sidebarOpen" class="my-2 border-t border-indigo-700/30"></div>

        <!-- Manajemen Armada -->
        <!-- Contoh untuk Manajemen Armada (lakukan hal yang sama untuk semua dropdown) -->
        <div x-data="{menuOpen: {{ request()->routeIs('trucks.*') || request()->routeIs('drivers.*') || request()->routeIs('fuel-purchases.*') ? 'true' : 'false' }} }" class="mb-1" x-id="['dropdown-button']">
            <button @click="Alpine.store('sidebar').closeOtherMenus($el.parentElement); menuOpen = !menuOpen" class="w-full flex items-center justify-between px-3 py-2.5 text-sm font-medium rounded-lg text-indigo-100 hover:bg-white/5 transition-all duration-150 focus:outline-none">
                <div class="flex items-center">
                    <i class="fas fa-truck w-5 text-center text-indigo-300 group-hover:text-white"></i>
                    <span x-show="sidebarOpen" class="ml-3">Manajemen Armada</span>
                </div>
                <i x-show="sidebarOpen" class="fas text-xs transition-transform duration-200" :class="{'fa-chevron-down transform rotate-0': menuOpen, 'fa-chevron-right transform -rotate-90': !menuOpen}"></i>
            </button>
            <div x-show="menuOpen" x-transition:enter="transition ease-out duration-200" x-transition:enter-start="opacity-0 -translate-y-1" x-transition:enter-end="opacity-100 translate-y-0" class="mt-1 space-y-1 pl-2">
                <a href="{{ route('trucks.index') }}" class="group flex items-center px-3 py-2 text-xs font-medium rounded-md text-indigo-100 hover:bg-white/5 transition-all duration-150 {{ request()->routeIs('trucks.*') ? 'bg-white/10 text-white' : '' }}">
                    <i class="fas fa-truck-moving w-5 text-center {{ request()->routeIs('trucks.*') ? 'text-white' : 'text-indigo-300 group-hover:text-white' }}"></i>
                    <span x-show="sidebarOpen" class="ml-3">Truk</span>
                </a>
                <a href="{{ route('drivers.index') }}" class="group flex items-center px-3 py-2 text-xs font-medium rounded-md text-indigo-100 hover:bg-white/5 transition-all duration-150 {{ request()->routeIs('drivers.*') ? 'bg-white/10 text-white' : '' }}">
                    <i class="fas fa-id-card w-5 text-center {{ request()->routeIs('drivers.*') ? 'text-white' : 'text-indigo-300 group-hover:text-white' }}"></i>
                    <span x-show="sidebarOpen" class="ml-3">Driver</span>
                </a>
                <a href="{{ route('fuel-purchases.index') }}" class="group flex items-center px-3 py-2 text-xs font-medium rounded-md text-indigo-100 hover:bg-white/5 transition-all duration-150 {{ request()->routeIs('fuel-purchases.*') ? 'bg-white/10 text-white' : '' }}">
                    <i class="fas fa-gas-pump w-5 text-center {{ request()->routeIs('fuel-purchases.*') ? 'text-white' : 'text-indigo-300 group-hover:text-white' }}"></i>
                    <span x-show="sidebarOpen" class="ml-3">Bahan Bakar</span>
                </a>
            </div>
        </div>

        <!-- Manajemen Operasional -->
        <div x-data="{menuOpen: {{ request()->routeIs('trips.*') || request()->routeIs('projects.*') || request()->routeIs('materials.*') ? 'true' : 'false' }} }" class="mb-1" x-id="['dropdown-button']">
            <button @click="Alpine.store('sidebar').closeOtherMenus($el.parentElement); menuOpen = !menuOpen" class="w-full flex items-center justify-between px-3 py-2.5 text-sm font-medium rounded-lg text-indigo-100 hover:bg-white/5 transition-all duration-150 focus:outline-none">
                <div class="flex items-center">
                    <i class="fas fa-route w-5 text-center text-indigo-300 group-hover:text-white"></i>
                    <span x-show="sidebarOpen" class="ml-3">Manajemen Operasional</span>
                </div>
                <i x-show="sidebarOpen" class="fas text-xs transition-transform duration-200" :class="{'fa-chevron-down transform rotate-0': menuOpen, 'fa-chevron-right transform -rotate-90': !menuOpen}"></i>
            </button>
            <div x-show="menuOpen" x-transition:enter="transition ease-out duration-200" x-transition:enter-start="opacity-0 -translate-y-1" x-transition:enter-end="opacity-100 translate-y-0" class="mt-1 space-y-1 pl-2">
                <a href="{{ route('trips.index') }}" class="group flex items-center px-3 py-2 text-xs font-medium rounded-md text-indigo-100 hover:bg-white/5 transition-all duration-150 {{ request()->routeIs('trips.*') ? 'bg-white/10 text-white' : '' }}">
                    <i class="fas fa-map-marked-alt w-5 text-center {{ request()->routeIs('trips.*') ? 'text-white' : 'text-indigo-300 group-hover:text-white' }}"></i>
                    <span x-show="sidebarOpen" class="ml-3">Trip/Perjalanan</span>
                </a>
                <!-- Ganti link yang ada dengan: -->
                <a href="{{ route('projects.index') }}" class="group flex items-center px-3 py-2 text-xs font-medium rounded-md text-indigo-100 hover:bg-white/5 transition-all duration-150 {{ request()->routeIs('projects.*') ? 'bg-white/10 text-white' : '' }}">
                    <i class="fas fa-project-diagram w-5 text-center {{ request()->routeIs('projects.*') ? 'text-white' : 'text-indigo-300 group-hover:text-white' }}"></i>
                    <span x-show="sidebarOpen" class="ml-3">Proyek</span>
                </a>
                <a href="{{ route('materials.index') }}" class="group flex items-center px-3 py-2 text-xs font-medium rounded-md text-indigo-100 hover:bg-white/5 transition-all duration-150 {{ request()->routeIs('materials.*') ? 'bg-white/10 text-white' : '' }}">
                    <i class="fas fa-boxes w-5 text-center {{ request()->routeIs('materials.*') ? 'text-white' : 'text-indigo-300 group-hover:text-white' }}"></i>
                    <span x-show="sidebarOpen" class="ml-3">Material</span>
                </a>
            </div>
        </div>

        <!-- Divider -->
        <div x-show="sidebarOpen" class="my-2 border-t border-indigo-700/30"></div>

        <!-- Manajemen Klien -->
        <a href="{{ route('clients.index') }}" class="group flex items-center px-3 py-2.5 text-sm font-medium rounded-lg mb-1 transition-all duration-150 {{ request()->routeIs('clients.*') ? 'bg-white/10 text-white shadow-sm' : 'text-indigo-100 hover:bg-white/5' }}">
            <i class="fas fa-users w-5 text-center {{ request()->routeIs('clients.*') ? 'text-white' : 'text-indigo-300 group-hover:text-white' }}"></i>
            <span x-show="sidebarOpen" class="ml-3">Manajemen Klien</span>
        </a>

        <!-- Manajemen Keuangan -->
        <div x-data="{menuOpen: {{ request()->routeIs('expenses.*') ? 'true' : 'false' }} }" class="mb-1" x-id="['dropdown-button']">
            <button @click="Alpine.store('sidebar').closeOtherMenus($el.parentElement); menuOpen = !menuOpen" class="w-full flex items-center justify-between px-3 py-2.5 text-sm font-medium rounded-lg text-indigo-100 hover:bg-white/5 transition-all duration-150 focus:outline-none">
                <div class="flex items-center">
                    <i class="fas fa-money-bill-wave w-5 text-center text-indigo-300 group-hover:text-white"></i>
                    <span x-show="sidebarOpen" class="ml-3">Manajemen Keuangan</span>
                </div>
                <i x-show="sidebarOpen" class="fas text-xs transition-transform duration-200" :class="{'fa-chevron-down transform rotate-0': menuOpen, 'fa-chevron-right transform -rotate-90': !menuOpen}"></i>
            </button>
            <div x-show="menuOpen" x-transition:enter="transition ease-out duration-200" x-transition:enter-start="opacity-0 -translate-y-1" x-transition:enter-end="opacity-100 translate-y-0" class="mt-1 space-y-1 pl-2">
                <a href="{{ route('expenses.index') }}" class="group flex items-center px-3 py-2 text-xs font-medium rounded-md text-indigo-100 hover:bg-white/5 transition-all duration-150 {{ request()->routeIs('expenses.*') ? 'bg-white/10 text-white' : '' }}">
                    <i class="fas fa-file-invoice-dollar w-5 text-center {{ request()->routeIs('expenses.*') ? 'text-white' : 'text-indigo-300 group-hover:text-white' }}"></i>
                    <span x-show="sidebarOpen" class="ml-3">Pengeluaran</span>
                </a>
                <a href="{{ route('incomes.index') }}" class="group flex items-center px-3 py-2 text-xs font-medium rounded-md text-indigo-100 hover:bg-white/5 transition-all duration-150 {{ request()->routeIs('incomes.*') ? 'bg-white/10 text-white' : '' }}">
                    <i class="fas fa-hand-holding-usd w-5 text-center {{ request()->routeIs('incomes.*') ? 'text-white' : 'text-indigo-300 group-hover:text-white' }}"></i>
                    <span x-show="sidebarOpen" class="ml-3">Pendapatan</span>
                </a>
                <a href="{{ route('reports.financial') }}" class="group flex items-center px-3 py-2 text-xs font-medium rounded-md text-indigo-100 hover:bg-white/5 transition-all duration-150 {{ request()->routeIs('reports.financial') ? 'bg-white/10 text-white' : '' }}">
                    <i class="fas fa-chart-pie w-5 text-center {{ request()->routeIs('reports.financial') ? 'text-white' : 'text-indigo-300 group-hover:text-white' }}"></i>
                    <span x-show="sidebarOpen" class="ml-3">Laporan Keuangan</span>
                </a>
            </div>
        </div>

        <!-- Laporan dan Analitik -->
        <div x-data="{menuOpen: {{ request()->routeIs('reports.*') ? 'true' : 'false' }} }" class="mb-1" x-id="['dropdown-button']">
            <button @click="Alpine.store('sidebar').closeOtherMenus($el.parentElement); menuOpen = !menuOpen" class="w-full flex items-center justify-between px-3 py-2.5 text-sm font-medium rounded-lg text-indigo-100 hover:bg-white/5 transition-all duration-150 focus:outline-none">
                <div class="flex items-center">
                    <i class="fas fa-chart-line w-5 text-center text-indigo-300 group-hover:text-white"></i>
                    <span x-show="sidebarOpen" class="ml-3">Laporan & Analitik</span>
                </div>
                <i x-show="sidebarOpen" class="fas text-xs transition-transform duration-200" :class="{'fa-chevron-down transform rotate-0': menuOpen, 'fa-chevron-right transform -rotate-90': !menuOpen}"></i>
            </button>
            <div x-show="menuOpen" x-transition:enter="transition ease-out duration-200" x-transition:enter-start="opacity-0 -translate-y-1" x-transition:enter-end="opacity-100 translate-y-0" class="mt-1 space-y-1 pl-2">
                <a href="{{ route('reports.trips') }}" class="group flex items-center px-3 py-2 text-xs font-medium rounded-md text-indigo-100 hover:bg-white/5 transition-all duration-150 {{ request()->routeIs('reports.trips') ? 'bg-white/10 text-white' : '' }}">
                    <i class="fas fa-truck-loading w-5 text-center {{ request()->routeIs('reports.trips') ? 'text-white' : 'text-indigo-300 group-hover:text-white' }}"></i>
                    <span x-show="sidebarOpen" class="ml-3">Laporan Trip</span>
                </a>
                <a href="{{ route('reports.fuel') }}" class="group flex items-center px-3 py-2 text-xs font-medium rounded-md text-indigo-100 hover:bg-white/5 transition-all duration-150 {{ request()->routeIs('reports.fuel') ? 'bg-white/10 text-white' : '' }}">
                    <i class="fas fa-gas-pump w-5 text-center {{ request()->routeIs('reports.fuel') ? 'text-white' : 'text-indigo-300 group-hover:text-white' }}"></i>
                    <span x-show="sidebarOpen" class="ml-3">Laporan Bahan Bakar</span>
                </a>
                <a href="{{ route('reports.expenses') }}" class="group flex items-center px-3 py-2 text-xs font-medium rounded-md text-indigo-100 hover:bg-white/5 transition-all duration-150 {{ request()->routeIs('reports.expenses') ? 'bg-white/10 text-white' : '' }}">
                    <i class="fas fa-file-invoice w-5 text-center {{ request()->routeIs('reports.expenses') ? 'text-white' : 'text-indigo-300 group-hover:text-white' }}"></i>
                    <span x-show="sidebarOpen" class="ml-3">Laporan Pengeluaran</span>
                </a>
                <a href="{{ route('reports.projects') }}" class="group flex items-center px-3 py-2 text-xs font-medium rounded-md text-indigo-100 hover:bg-white/5 transition-all duration-150 {{ request()->routeIs('reports.projects') ? 'bg-white/10 text-white' : '' }}">
                    <i class="fas fa-tasks w-5 text-center {{ request()->routeIs('reports.projects') ? 'text-white' : 'text-indigo-300 group-hover:text-white' }}"></i>
                    <span x-show="sidebarOpen" class="ml-3">Laporan Proyek</span>
                </a>
            </div>
        </div>

        <!-- Divider -->
        <div x-show="sidebarOpen" class="my-2 border-t border-indigo-700/30"></div>

        <!-- Pengumuman -->
        <a href="{{ route('announcements.index') }}" class="group flex items-center px-3 py-2.5 text-sm font-medium rounded-lg mb-1 transition-all duration-150 {{ request()->routeIs('announcements.*') ? 'bg-white/10 text-white shadow-sm' : 'text-indigo-100 hover:bg-white/5' }}">
            <i class="fas fa-bullhorn w-5 text-center {{ request()->routeIs('announcements.*') ? 'text-white' : 'text-indigo-300 group-hover:text-white' }}"></i>
            <span x-show="sidebarOpen" class="ml-3">Pengumuman</span>
        </a>

        <!-- Administrasi Sistem -->
        <div x-data="{menuOpen: {{ request()->routeIs('settings.*') || request()->routeIs('users.*') || request()->routeIs('roles.*') || request()->routeIs('permissions.*') ? 'true' : 'false' }}}" class="mb-1" x-id="['dropdown-button']">
            <button @click="Alpine.store('sidebar').closeOtherMenus($el.parentElement); menuOpen = !menuOpen" class="w-full flex items-center justify-between px-3 py-2.5 text-sm font-medium rounded-lg text-indigo-100 hover:bg-white/5 transition-all duration-150 focus:outline-none">
                <div class="flex items-center">
                    <i class="fas fa-cogs w-5 text-center text-indigo-300 group-hover:text-white"></i>
                    <span x-show="sidebarOpen" class="ml-3">Manajemen Sistem</span>
                </div>
                <i x-show="sidebarOpen" class="fas text-xs transition-transform duration-200" :class="{'fa-chevron-down transform rotate-0': menuOpen, 'fa-chevron-right transform -rotate-90': !menuOpen}"></i>
            </button>
            <div x-show="menuOpen" x-transition:enter="transition ease-out duration-200" x-transition:enter-start="opacity-0 -translate-y-1" x-transition:enter-end="opacity-100 translate-y-0" class="mt-1 space-y-1 pl-2">
                <a href="{{ route('users.index') }}" class="group flex items-center px-3 py-2 text-xs font-medium rounded-md text-indigo-100 hover:bg-white/5 transition-all duration-150 {{ request()->routeIs('users.*') ? 'bg-white/10 text-white' : '' }}">
                    <i class="fas fa-users w-5 text-center {{ request()->routeIs('users.*') ? 'text-white' : 'text-indigo-300 group-hover:text-white' }}"></i>
                    <span x-show="sidebarOpen" class="ml-3">Pengguna</span>
                </a>
                <a href="{{ route('roles.index') }}" class="group flex items-center px-3 py-2 text-xs font-medium rounded-md text-indigo-100 hover:bg-white/5 transition-all duration-150 {{ request()->routeIs('roles.*') ? 'bg-white/10 text-white' : '' }}">
                    <i class="fas fa-user-tag w-5 text-center {{ request()->routeIs('roles.*') ? 'text-white' : 'text-indigo-300 group-hover:text-white' }}"></i>
                    <span x-show="sidebarOpen" class="ml-3">Peran</span>
                </a>
                <a href="{{ route('permissions.index') }}" class="group flex items-center px-3 py-2 text-xs font-medium rounded-md text-indigo-100 hover:bg-white/5 transition-all duration-150 {{ request()->routeIs('permissions.*') ? 'bg-white/10 text-white' : '' }}">
                    <i class="fas fa-key w-5 text-center {{ request()->routeIs('permissions.*') ? 'text-white' : 'text-indigo-300 group-hover:text-white' }}"></i>
                    <span x-show="sidebarOpen" class="ml-3">Izin</span>
                </a>
                <a href="{{ route('settings.index') }}" class="group flex items-center px-3 py-2 text-xs font-medium rounded-md text-indigo-100 hover:bg-white/5 transition-all duration-150 {{ request()->routeIs('settings.*') ? 'bg-white/10 text-white' : '' }}">
                    <i class="fas fa-sliders-h w-5 text-center {{ request()->routeIs('settings.*') ? 'text-white' : 'text-indigo-300 group-hover:text-white' }}"></i>
                    <span x-show="sidebarOpen" class="ml-3">Pengaturan Sistem</span>
                </a>
            </div>
        </div>
    </nav>
</div>