<x-app-layout>
    <x-slot name="header">
        <div class="flex justify-between items-center">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">
                {{ __('Riwayat Retase Manual') }} - {{ $driver->name }}
            </h2>
            <a href="{{ route('drivers.show', $driver) }}" class="bg-gray-500 hover:bg-gray-700 text-white font-bold py-2 px-4 rounded">
                <i class="fas fa-arrow-left mr-2"></i>Kembali
            </a>
        </div>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900">
                    @if($manualTripCounts->count() > 0)
                        <div class="overflow-x-auto">
                            <table class="min-w-full bg-white">
                                <thead>
                                    <tr>
                                        <th class="py-3 px-4 border-b border-gray-200 bg-gray-50 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Tanggal</th>
                                        <th class="py-3 px-4 border-b border-gray-200 bg-gray-50 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Perjalanan Selesai</th>
                                        <th class="py-3 px-4 border-b border-gray-200 bg-gray-50 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Perjalanan Berlangsung</th>
                                        <th class="py-3 px-4 border-b border-gray-200 bg-gray-50 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Total</th>
                                        <th class="py-3 px-4 border-b border-gray-200 bg-gray-50 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Ditambahkan Oleh</th>
                                        <th class="py-3 px-4 border-b border-gray-200 bg-gray-50 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Catatan</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($manualTripCounts as $count)
                                        <tr>
                                            <td class="py-4 px-4 border-b border-gray-200">{{ $count->created_at->format('d/m/Y H:i') }}</td>
                                            <td class="py-4 px-4 border-b border-gray-200">{{ $count->completed_trips }}</td>
                                            <td class="py-4 px-4 border-b border-gray-200">{{ $count->ongoing_trips }}</td>
                                            <td class="py-4 px-4 border-b border-gray-200">{{ $count->completed_trips + $count->ongoing_trips }}</td>
                                            <td class="py-4 px-4 border-b border-gray-200">{{ $count->addedBy->name }}</td>
                                            <td class="py-4 px-4 border-b border-gray-200">{{ $count->notes ?? '-' }}</td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                        <div class="mt-4">
                            {{ $manualTripCounts->links() }}
                        </div>
                    @else
                        <p class="text-center py-4">Belum ada data retase manual untuk driver ini.</p>
                    @endif
                </div>
            </div>
        </div>
    </div>
</x-app-layout>