<x-app-layout>
    <x-slot name="header">
        <div class="flex justify-between items-center">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">
                {{ __('Detail Material') }}
            </h2>
            <div class="flex space-x-2">
                <a href="{{ route('materials.edit', $material) }}" class="bg-yellow-500 hover:bg-yellow-700 text-white font-bold py-2 px-4 rounded">
                    <i class="fas fa-edit mr-2"></i>Edit
                </a>
                <a href="{{ route('materials.index') }}" class="bg-gray-500 hover:bg-gray-700 text-white font-bold py-2 px-4 rounded">
                    <i class="fas fa-arrow-left mr-2"></i>Kembali
                </a>
            </div>
        </div>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div class="bg-gray-50 p-4 rounded-lg">
                            <h3 class="text-lg font-semibold mb-4 border-b pb-2">Informasi Material</h3>
                            
                            <div class="grid grid-cols-2 gap-4">
                                <div class="text-gray-600">ID:</div>
                                <div class="font-medium">{{ $material->id }}</div>
                                
                                <div class="text-gray-600">Nama Material:</div>
                                <div class="font-medium">{{ $material->name }}</div>
                                
                                <div class="text-gray-600">Unit:</div>
                                <div class="font-medium">{{ $material->unit }}</div>
                                
                                <div class="text-gray-600">Harga per Unit:</div>
                                <div class="font-medium">Rp {{ number_format($material->price_per_unit, 0, ',', '.') }}</div>
                                
                                <div class="text-gray-600">Stok:</div>
                                <div class="font-medium">{{ $material->stock }} {{ $material->unit }}</div>
                                
                                <div class="text-gray-600">Proyek:</div>
                                <div class="font-medium">{{ $material->project ? $material->project->name : 'Tidak ada' }}</div>
                            </div>
                        </div>
                        
                        <div class="bg-gray-50 p-4 rounded-lg">
                            <h3 class="text-lg font-semibold mb-4 border-b pb-2">Deskripsi</h3>
                            <p class="whitespace-pre-line">{{ $material->description ?: 'Tidak ada deskripsi' }}</p>
                        </div>
                    </div>
                    
                    <div class="mt-6 bg-gray-50 p-4 rounded-lg">
                        <h3 class="text-lg font-semibold mb-4 border-b pb-2">Catatan</h3>
                        <p class="whitespace-pre-line">{{ $material->notes ?: 'Tidak ada catatan' }}</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>