@extends('layouts.app')

@section('content')
<div class="container mx-auto px-4 py-6">
    <div class="flex justify-between items-center mb-6">
        <h1 class="text-2xl font-bold text-gray-800">Laporan Bahan Bakar</h1>
        <div class="flex space-x-2">
            <button onclick="exportToPDF()" class="bg-red-600 hover:bg-red-700 text-white font-bold py-2 px-4 rounded">
                <i class="fas fa-file-pdf mr-2"></i>Export PDF
            </button>
            <button onclick="exportToExcel()" class="bg-green-600 hover:bg-green-700 text-white font-bold py-2 px-4 rounded">
                <i class="fas fa-file-excel mr-2"></i>Export Excel
            </button>
        </div>
    </div>

    <div class="bg-white rounded-lg shadow-md overflow-hidden p-6">
        <h2 class="text-lg font-semibold mb-4">Filter Laporan</h2>
        <form action="{{ route('reports.fuel') }}" method="GET" class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-5 gap-4">
            <div>
                <label for="start_date" class="block text-sm font-medium text-gray-700 mb-1">Tanggal Mulai</label>
                <input type="date" id="start_date" name="start_date" value="{{ $startDate }}" class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
            </div>
            <div>
                <label for="end_date" class="block text-sm font-medium text-gray-700 mb-1">Tanggal Akhir</label>
                <input type="date" id="end_date" name="end_date" value="{{ $endDate }}" class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
            </div>
            <div>
                <label for="truck_id" class="block text-sm font-medium text-gray-700 mb-1">Truk</label>
                <select id="truck_id" name="truck_id" class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                    <option value="">Semua Truk</option>
                    @foreach($trucks as $truck)
                        <option value="{{ $truck->id }}" {{ $truckId == $truck->id ? 'selected' : '' }}>{{ $truck->license_plate }} - {{ $truck->model }}</option>
                    @endforeach
                </select>
            </div>
            <div>
                <label for="fuel_type" class="block text-sm font-medium text-gray-700 mb-1">Jenis Bahan Bakar</label>
                <select id="fuel_type" name="fuel_type" class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                    <option value="">Semua Jenis</option>
                    @foreach($fuelTypes as $type)
                        <option value="{{ $type }}" {{ $fuelType == $type ? 'selected' : '' }}>{{ $type }}</option>
                    @endforeach
                </select>
            </div>
            <div>
                <label for="location" class="block text-sm font-medium text-gray-700 mb-1">Lokasi</label>
                <input type="text" id="location" name="location" value="{{ $location }}" class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50" placeholder="Lokasi pengisian">
            </div>
            <div class="lg:col-span-5 flex justify-end">
                <button type="submit" class="bg-blue-600 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded">
                    <i class="fas fa-filter mr-2"></i>Filter
                </button>
            </div>
        </form>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6 mb-6">
        <div class="bg-white rounded-lg shadow-md p-6">
            <h3 class="text-lg font-semibold mb-2">Total Pengisian</h3>
            <p class="text-3xl font-bold text-blue-600">{{ $fuelPurchases->count() }}</p>
        </div>
        <div class="bg-white rounded-lg shadow-md p-6">
            <h3 class="text-lg font-semibold mb-2">Total Volume</h3>
            <p class="text-3xl font-bold text-green-600">{{ number_format($totalVolume, 1, ',', '.') }} liter</p>
        </div>
        <div class="bg-white rounded-lg shadow-md p-6">
            <h3 class="text-lg font-semibold mb-2">Total Biaya</h3>
            <p class="text-3xl font-bold text-red-600">Rp {{ number_format($totalCost, 0, ',', '.') }}</p>
        </div>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6 mb-6">
        <div class="bg-white rounded-lg shadow-md p-6">
            <h3 class="text-lg font-semibold mb-4">Konsumsi Bahan Bakar per Truk</h3>
            <canvas id="fuelByTruckChart" width="400" height="300"></canvas>
        </div>
        <div class="bg-white rounded-lg shadow-md p-6">
            <h3 class="text-lg font-semibold mb-4">Biaya Bahan Bakar per Bulan</h3>
            <canvas id="fuelByMonthChart" width="400" height="300"></canvas>
        </div>
    </div>

    <div class="bg-white rounded-lg shadow-md overflow-hidden">
        <h3 class="text-lg font-semibold p-6 border-b">Daftar Pengisian Bahan Bakar</h3>
        @if($fuelPurchases->count() > 0)
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Tanggal</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Truk</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Jenis BBM</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Volume (L)</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Harga/L</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Total Biaya</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Lokasi</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        @foreach($fuelPurchases as $purchase)
                            <tr>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">{{ $purchase->purchase_date->format('d/m/Y') }}</td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">{{ $purchase->truck->license_plate }}</td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">{{ $purchase->fuel_type }}</td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">{{ number_format($purchase->volume, 1, ',', '.') }}</td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">Rp {{ number_format($purchase->price_per_liter, 0, ',', '.') }}</td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">Rp {{ number_format($purchase->total_cost, 0, ',', '.') }}</td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">{{ $purchase->location }}</td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        @else
            <div class="p-6 text-center text-gray-500">
                Tidak ada data pengisian bahan bakar yang sesuai dengan filter.
            </div>
        @endif
    </div>
</div>

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    // Data untuk grafik konsumsi bahan bakar per truk
    const truckLabels = {!! json_encode($fuelByTruck->keys()) !!};
    const truckData = {!! json_encode($fuelByTruck->values()) !!};
    
    // Buat grafik konsumsi bahan bakar per truk
    const ctxTruck = document.getElementById('fuelByTruckChart').getContext('2d');
    new Chart(ctxTruck, {
        type: 'bar',
        data: {
            labels: truckLabels,
            datasets: [{
                label: 'Volume (Liter)',
                data: truckData,
                backgroundColor: '#4F46E5',
                borderWidth: 1
            }]
        },
        options: {
            responsive: true,
            scales: {
                y: {
                    beginAtZero: true,
                    ticks: {
                        callback: function(value) {
                            return value.toLocaleString('id-ID') + ' L';
                        }
                    }
                }
            }
        }
    });
    
    // Data untuk grafik biaya bahan bakar per bulan
    const monthLabels = {!! json_encode($fuelByMonth->keys()) !!};
    const monthData = {!! json_encode($fuelByMonth->values()) !!};
    
    // Buat grafik biaya bahan bakar per bulan
    const ctxMonth = document.getElementById('fuelByMonthChart').getContext('2d');
    new Chart(ctxMonth, {
        type: 'line',
        data: {
            labels: monthLabels,
            datasets: [{
                label: 'Biaya (Rp)',
                data: monthData,
                backgroundColor: 'rgba(239, 68, 68, 0.2)',
                borderColor: '#EF4444',
                borderWidth: 2,
                fill: true,
                tension: 0.1
            }]
        },
        options: {
            responsive: true,
            scales: {
                y: {
                    beginAtZero: true,
                    ticks: {
                        callback: function(value) {
                            return 'Rp ' + value.toLocaleString('id-ID');
                        }
                    }
                }
            }
        }
    });
    
    // Fungsi untuk export ke PDF
    function exportToPDF() {
        window.location.href = '{{ route("reports.fuel.export.pdf") }}' + window.location.search;
    }
    
    // Fungsi untuk export ke Excel
    function exportToExcel() {
        window.location.href = '{{ route("reports.fuel.export.excel") }}' + window.location.search;
    }
</script>
@endpush
@endsection