<x-app-layout>
    <x-slot name="header">
        <div class="flex justify-between items-center">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">
                {{ __('Tambah Perjalanan Baru') }}
            </h2>
            <a href="{{ route('trips.index') }}" class="bg-gray-500 hover:bg-gray-700 text-white font-bold py-2 px-4 rounded">
                <i class="fas fa-arrow-left mr-2"></i>Kembali
            </a>
        </div>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900">
                    <form method="POST" action="{{ route('trips.store') }}">
                        @csrf
                        
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <!-- Driver -->
                            <div>
                                <x-input-label for="driver_id" :value="__('Driver')" />
                                <select id="driver_id" name="driver_id" class="border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm block mt-1 w-full" required>
                                    <option value="">Pilih Driver</option>
                                    @foreach ($drivers as $driver)
                                        <option value="{{ $driver->id }}" {{ old('driver_id') == $driver->id ? 'selected' : '' }}>
                                            {{ $driver->name }} {{ $driver->truck_id ? '- ' . $driver->truck->plate_number : '' }}
                                        </option>
                                    @endforeach
                                </select>
                                <x-input-error :messages="$errors->get('driver_id')" class="mt-2" />
                            </div>

                            <!-- Truk -->
                            <div>
                                <x-input-label for="truck_id" :value="__('Truk')" />
                                <select id="truck_id" name="truck_id" class="border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm block mt-1 w-full" required>
                                    <option value="">Pilih Truk</option>
                                    @foreach ($trucks as $truck)
                                        <option value="{{ $truck->id }}" {{ old('truck_id') == $truck->id ? 'selected' : '' }}>
                                            {{ $truck->plate_number }} - {{ $truck->brand }} {{ $truck->model }}
                                        </option>
                                    @endforeach
                                </select>
                                <x-input-error :messages="$errors->get('truck_id')" class="mt-2" />
                            </div>

                            <!-- Proyek -->
                            <div>
                                <x-input-label for="project_id" :value="__('Proyek (Opsional)')" />
                                <select id="project_id" name="project_id" class="border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm block mt-1 w-full">
                                    <option value="">Pilih Proyek (Opsional)</option>
                                    @foreach ($projects as $project)
                                        <option value="{{ $project->id }}" {{ old('project_id') == $project->id ? 'selected' : '' }}>
                                            {{ $project->name }}
                                        </option>
                                    @endforeach
                                </select>
                                <x-input-error :messages="$errors->get('project_id')" class="mt-2" />
                            </div>

                            <!-- Tanggal Mulai -->
                            <div>
                                <x-input-label for="start_date" :value="__('Tanggal & Waktu Mulai')" />
                                <x-text-input id="start_date" class="block mt-1 w-full" type="datetime-local" name="start_date" :value="old('start_date')" required />
                                <x-input-error :messages="$errors->get('start_date')" class="mt-2" />
                            </div>

                            <!-- Tanggal Selesai -->
                            <div>
                                <x-input-label for="end_date" :value="__('Tanggal & Waktu Selesai (Opsional)')" />
                                <x-text-input id="end_date" class="block mt-1 w-full" type="datetime-local" name="end_date" :value="old('end_date')" />
                                <x-input-error :messages="$errors->get('end_date')" class="mt-2" />
                            </div>

                            <!-- Odometer Awal -->
                            <div>
                                <x-input-label for="start_odometer" :value="__('Odometer Awal (km)')" />
                                <x-text-input id="start_odometer" class="block mt-1 w-full" type="number" name="start_odometer" :value="old('start_odometer')" step="0.01" required />
                                <x-input-error :messages="$errors->get('start_odometer')" class="mt-2" />
                            </div>

                            <!-- Odometer Akhir -->
                            <div>
                                <x-input-label for="end_odometer" :value="__('Odometer Akhir (km) (Opsional)')" />
                                <x-text-input id="end_odometer" class="block mt-1 w-full" type="number" name="end_odometer" :value="old('end_odometer')" step="0.01" />
                                <x-input-error :messages="$errors->get('end_odometer')" class="mt-2" />
                            </div>

                            <!-- Jarak -->
                            <div>
                                <x-input-label for="distance" :value="__('Jarak (km) (Opsional)')" />
                                <x-text-input id="distance" class="block mt-1 w-full" type="number" name="distance" :value="old('distance')" step="0.01" />
                                <x-input-error :messages="$errors->get('distance')" class="mt-2" />
                            </div>

                            <!-- Konsumsi BBM -->
                            <div>
                                <x-input-label for="fuel_consumption" :value="__('Konsumsi BBM (liter) (Opsional)')" />
                                <x-text-input id="fuel_consumption" class="block mt-1 w-full" type="number" name="fuel_consumption" :value="old('fuel_consumption')" step="0.01" />
                                <x-input-error :messages="$errors->get('fuel_consumption')" class="mt-2" />
                            </div>

                            <!-- Status -->
                            <div>
                                <x-input-label for="status" :value="__('Status')" />
                                <select id="status" name="status" class="border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm block mt-1 w-full" required>
                                    @foreach ($statuses as $value => $label)
                                        <option value="{{ $value }}" {{ old('status', 'ongoing') == $value ? 'selected' : '' }}>
                                            {{ $label }}
                                        </option>
                                    @endforeach
                                </select>
                                <x-input-error :messages="$errors->get('status')" class="mt-2" />
                            </div>
                        </div>

                        <!-- Catatan -->
                        <div class="mt-4">
                            <x-input-label for="notes" :value="__('Catatan (Opsional)')" />
                            <textarea id="notes" name="notes" rows="4" class="border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm block mt-1 w-full">{{ old('notes') }}</textarea>
                            <x-input-error :messages="$errors->get('notes')" class="mt-2" />
                        </div>

                        <div class="flex items-center justify-end mt-4">
                            <x-primary-button>
                                {{ __('Simpan') }}
                            </x-primary-button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const endOdometerInput = document.getElementById('end_odometer');
            const startOdometerInput = document.getElementById('start_odometer');
            const distanceInput = document.getElementById('distance');

            function calculateDistance() {
                const startOdometer = parseFloat(startOdometerInput.value) || 0;
                const endOdometer = parseFloat(endOdometerInput.value) || 0;
                
                if (endOdometer > startOdometer) {
                    distanceInput.value = (endOdometer - startOdometer).toFixed(2);
                }
            }

            endOdometerInput.addEventListener('input', calculateDistance);
            startOdometerInput.addEventListener('input', calculateDistance);
            
            // Inisialisasi Select2 untuk dropdown
            $(document).ready(function() {
                $('#driver_id, #truck_id, #project_id, #status').select2({
                    placeholder: 'Pilih...',
                    allowClear: true
                });
                
                // Auto-select driver berdasarkan truck
                $('#truck_id').change(function() {
                    const truckId = $(this).val();
                    if (truckId) {
                        $.ajax({
                            url: window.location.origin + '/obm/public/api/drivers-by-truck/' + truckId,
                            type: 'GET',
                            dataType: 'json',
                            success: function(data) {
                                if (data && data.length > 0) {
                                    $('#driver_id').val(data[0].id).trigger('change');
                                }
                            }
                        });
                    }
                });
            });
        });
    </script>
</x-app-layout>