<x-app-layout>
    <x-slot name="header">
        <div class="flex justify-between items-center">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">
                {{ __('Manajemen Perjalanan') }}
            </h2>
            <a href="{{ route('trips.create') }}" class="bg-indigo-600 hover:bg-indigo-700 text-white font-bold py-2 px-4 rounded">
                <i class="fas fa-plus mr-2"></i>Tambah Perjalanan
            </a>
        </div>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900">
                    @if (session('success'))
                        <div class="bg-green-100 border-l-4 border-green-500 text-green-700 p-4 mb-4" role="alert">
                            <p>{{ session('success') }}</p>
                        </div>
                    @endif

                    <div class="overflow-x-auto">
                        <table class="min-w-full bg-white">
                            <thead>
                                <tr class="bg-gray-100 text-gray-700 [&>th]:py-2 [&>th]:px-4 [&>th]:text-left [&>th]:font-semibold">
                                    <th>ID</th>
                                    <th>Driver</th>
                                    <th>Truk</th>
                                    <th>Proyek</th>
                                    <th>Tanggal Mulai</th>
                                    <th>Status</th>
                                    <th>Jarak (km)</th>
                                    <th>Aksi</th>
                                </tr>
                            </thead>
                            <tbody class="divide-y divide-gray-200">
                                @forelse ($trips as $trip)
                                    <tr class="hover:bg-gray-50 [&>td]:py-2 [&>td]:px-4">
                                        <td>{{ $trip->id }}</td>
                                        <td>{{ $trip->driver->name }}</td>
                                        <td>{{ $trip->truck->plate_number }}</td>
                                        <td>{{ $trip->project->name ?? 'Tidak ada' }}</td>
                                        <td>{{ $trip->start_date->format('d/m/Y H:i') }}</td>
                                        <td>
                                            @if($trip->status == 'ongoing')
                                                <span class="px-2 py-1 text-xs rounded-full bg-blue-100 text-blue-800">Sedang Berlangsung</span>
                                            @elseif($trip->status == 'completed')
                                                <span class="px-2 py-1 text-xs rounded-full bg-green-100 text-green-800">Selesai</span>
                                            @elseif($trip->status == 'cancelled')
                                                <span class="px-2 py-1 text-xs rounded-full bg-red-100 text-red-800">Dibatalkan</span>
                                            @endif
                                        </td>
                                        <td>{{ $trip->distance ?? '-' }}</td>
                                        <td class="flex space-x-2">
                                            <a href="{{ route('trips.show', $trip) }}" class="text-blue-500 hover:text-blue-700">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            <a href="{{ route('trips.edit', $trip) }}" class="text-yellow-500 hover:text-yellow-700">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            <form action="{{ route('trips.destroy', $trip) }}" method="POST" class="inline-block">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="text-red-500 hover:text-red-700" onclick="return confirm('Apakah Anda yakin ingin menghapus perjalanan ini?')">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="8" class="py-4 text-center text-gray-500">Tidak ada data perjalanan</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <div class="mt-4">
                        {{ $trips->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>