<x-app-layout>
    <x-slot name="header">
        <div class="flex justify-between items-center">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">
                {{ __('Manajemen Truk') }}
            </h2>
            <a href="{{ route('trucks.create') }}" class="bg-indigo-600 hover:bg-indigo-700 text-white font-bold py-2 px-4 rounded">
                <i class="fas fa-plus mr-2"></i>Tambah Truk
            </a>
        </div>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900">
                    @if (session('success'))
                        <div class="bg-green-100 border-l-4 border-green-500 text-green-700 p-4 mb-4" role="alert">
                            <p>{{ session('success') }}</p>
                        </div>
                    @endif

                    <div class="overflow-x-auto">
                        <table class="min-w-full bg-white">
                            <thead class="bg-gray-100">
                                <tr>
                                    <th class="py-3 px-4 text-left">No. Plat</th>
                                    <th class="py-3 px-4 text-left">Merek</th>
                                    <th class="py-3 px-4 text-left">Model</th>
                                    <th class="py-3 px-4 text-left">Tahun</th>
                                    <th class="py-3 px-4 text-left">Kapasitas</th>
                                    <th class="py-3 px-4 text-left">Status</th>
                                    <th class="py-3 px-4 text-left">Aksi</th>
                                </tr>
                            </thead>
                            <tbody class="divide-y divide-gray-200">
                                @forelse ($trucks as $truck)
                                    <tr class="hover:bg-gray-50">
                                        <td class="py-3 px-4">{{ $truck->plate_number }}</td>
                                        <td class="py-3 px-4">{{ $truck->brand }}</td>
                                        <td class="py-3 px-4">{{ $truck->model }}</td>
                                        <td class="py-3 px-4">{{ $truck->year }}</td>
                                        <td class="py-3 px-4">{{ $truck->capacity }}</td>
                                        <td class="py-3 px-4">
                                            <span class="px-2 py-1 rounded text-xs font-semibold
                                                {{ $truck->status == 'active' ? 'bg-green-100 text-green-800' : '' }}
                                                {{ $truck->status == 'maintenance' ? 'bg-yellow-100 text-yellow-800' : '' }}
                                                {{ $truck->status == 'inactive' ? 'bg-red-100 text-red-800' : '' }}
                                            ">
                                                {{ $truck->status == 'active' ? 'Aktif' : '' }}
                                                {{ $truck->status == 'maintenance' ? 'Maintenance' : '' }}
                                                {{ $truck->status == 'inactive' ? 'Tidak Aktif' : '' }}
                                            </span>
                                        </td>
                                        <td class="py-3 px-4">
                                            <div class="flex space-x-2">
                                                <a href="{{ route('trucks.show', $truck) }}" class="text-blue-500 hover:text-blue-700">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                <a href="{{ route('trucks.edit', $truck) }}" class="text-yellow-500 hover:text-yellow-700">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                <form action="{{ route('trucks.destroy', $truck) }}" method="POST" class="inline">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="text-red-500 hover:text-red-700" onclick="return confirm('Apakah Anda yakin ingin menghapus truk ini?')">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                </form>
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="7" class="py-3 px-4 text-center">Tidak ada data truk</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                    
                    <div class="mt-4">
                        {{ $trucks->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>