<x-app-layout>
    <x-slot name="header">
        <div class="flex justify-between items-center">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">
                {{ __('Detail Truk') }}
            </h2>
            <div class="flex space-x-2">
                <a href="{{ route('trucks.edit', $truck) }}" class="bg-yellow-500 hover:bg-yellow-700 text-white font-bold py-2 px-4 rounded">
                    <i class="fas fa-edit mr-2"></i>Edit
                </a>
                <a href="{{ route('trucks.index') }}" class="bg-gray-500 hover:bg-gray-700 text-white font-bold py-2 px-4 rounded">
                    <i class="fas fa-arrow-left mr-2"></i>Kembali
                </a>
            </div>
        </div>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div class="bg-gray-50 p-4 rounded-lg">
                            <h3 class="text-lg font-semibold mb-4 border-b pb-2">Informasi Umum</h3>
                            
                            <div class="grid grid-cols-2 gap-4">
                                <div class="text-gray-600">Nomor Plat:</div>
                                <div class="font-medium">{{ $truck->plate_number }}</div>
                                
                                <div class="text-gray-600">Merek:</div>
                                <div class="font-medium">{{ $truck->brand }}</div>
                                
                                <div class="text-gray-600">Model:</div>
                                <div class="font-medium">{{ $truck->model }}</div>
                                
                                <div class="text-gray-600">Tahun:</div>
                                <div class="font-medium">{{ $truck->year }}</div>
                                
                                <div class="text-gray-600">Kapasitas:</div>
                                <div class="font-medium">{{ $truck->capacity }}</div>
                                
                                <div class="text-gray-600">Jenis Bahan Bakar:</div>
                                <div class="font-medium">{{ $truck->fuel_type }}</div>
                                
                                <div class="text-gray-600">Status:</div>
                                <div>
                                    <span class="px-2 py-1 rounded text-xs font-semibold
                                        {{ $truck->status == 'active' ? 'bg-green-100 text-green-800' : '' }}
                                        {{ $truck->status == 'maintenance' ? 'bg-yellow-100 text-yellow-800' : '' }}
                                        {{ $truck->status == 'inactive' ? 'bg-red-100 text-red-800' : '' }}
                                    ">
                                        {{ $truck->status == 'active' ? 'Aktif' : '' }}
                                        {{ $truck->status == 'maintenance' ? 'Maintenance' : '' }}
                                        {{ $truck->status == 'inactive' ? 'Tidak Aktif' : '' }}
                                    </span>
                                </div>
                            </div>
                        </div>
                        
                        <div class="bg-gray-50 p-4 rounded-lg">
                            <h3 class="text-lg font-semibold mb-4 border-b pb-2">Informasi Pemeliharaan</h3>
                            
                            <div class="grid grid-cols-2 gap-4">
                                <div class="text-gray-600">Tanggal Pembelian:</div>
                                <div class="font-medium">{{ $truck->purchase_date->format('d/m/Y') }}</div>
                                
                                <div class="text-gray-600">Service Terakhir:</div>
                                <div class="font-medium">{{ $truck->last_service_date ? $truck->last_service_date->format('d/m/Y') : 'Belum ada' }}</div>
                                
                                <div class="text-gray-600">Service Berikutnya:</div>
                                <div class="font-medium">{{ $truck->next_service_date ? $truck->next_service_date->format('d/m/Y') : 'Belum dijadwalkan' }}</div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="mt-6 bg-gray-50 p-4 rounded-lg">
                        <h3 class="text-lg font-semibold mb-4 border-b pb-2">Catatan</h3>
                        <p class="whitespace-pre-line">{{ $truck->notes ?: 'Tidak ada catatan' }}</p>
                    </div>
                    
                    <!-- Riwayat Maintenance -->
                    <div class="mt-6">
                        <div class="flex justify-between items-center mb-4">
                            <h3 class="text-lg font-semibold">Riwayat Maintenance</h3>
                            <a href="{{ route('truck-maintenances.create', $truck) }}" class="bg-indigo-600 hover:bg-indigo-700 text-white font-bold py-1 px-3 rounded text-sm">
                                <i class="fas fa-plus mr-1"></i>Tambah Maintenance
                            </a>
                        </div>
                        
                        @if($truck->maintenances->count() > 0)
                            <div class="overflow-x-auto bg-white rounded-lg shadow">
                                <table class="min-w-full divide-y divide-gray-200">
                                    <thead class="bg-gray-50">
                                        <tr>
                                            <th scope="col" class="px-3 py-2 text-left text-xs font-medium text-gray-500 uppercase">Tanggal</th>
                                            <th scope="col" class="px-3 py-2 text-left text-xs font-medium text-gray-500 uppercase">Jenis</th>
                                            <th scope="col" class="px-3 py-2 text-left text-xs font-medium text-gray-500 uppercase">Deskripsi</th>
                                            <th scope="col" class="px-3 py-2 text-left text-xs font-medium text-gray-500 uppercase">KM</th>
                                            <th scope="col" class="px-3 py-2 text-left text-xs font-medium text-gray-500 uppercase">Biaya</th>
                                            <th scope="col" class="px-3 py-2 text-left text-xs font-medium text-gray-500 uppercase">Status</th>
                                            <th scope="col" class="px-3 py-2 text-left text-xs font-medium text-gray-500 uppercase">Aksi</th>
                                        </tr>
                                    </thead>
                                    <tbody class="bg-white divide-y divide-gray-200">
                                        @foreach($truck->maintenances->sortByDesc('maintenance_date') as $maintenance)
                                            <tr class="hover:bg-gray-50">
                                                <td class="px-3 py-2 text-sm text-gray-900">{{ $maintenance->maintenance_date->format('d/m/Y') }}</td>
                                                <td class="px-3 py-2 text-sm text-gray-900">{{ $maintenance->maintenance_type_label }}</td>
                                                <td class="px-3 py-2 text-sm text-gray-900">{{ Str::limit($maintenance->description, 50) }}</td>
                                                <td class="px-3 py-2 text-sm text-gray-900">{{ $maintenance->odometer_reading ? number_format($maintenance->odometer_reading) . ' km' : '-' }}</td>
                                                <td class="px-3 py-2 text-sm text-gray-900">Rp {{ number_format($maintenance->cost, 0, ',', '.') }}</td>
                                                <td class="px-3 py-2 text-sm">
                                                    <span class="px-2 py-1 rounded text-xs font-semibold
                                                        {{ $maintenance->status == 'completed' ? 'bg-green-100 text-green-800' : '' }}
                                                        {{ $maintenance->status == 'in_progress' ? 'bg-yellow-100 text-yellow-800' : '' }}
                                                        {{ $maintenance->status == 'scheduled' ? 'bg-blue-100 text-blue-800' : '' }}
                                                    ">
                                                        {{ $maintenance->status == 'completed' ? 'Selesai' : '' }}
                                                        {{ $maintenance->status == 'in_progress' ? 'Sedang Dikerjakan' : '' }}
                                                        {{ $maintenance->status == 'scheduled' ? 'Dijadwalkan' : '' }}
                                                    </span>
                                                </td>
                                                <td class="px-3 py-2 text-sm font-medium">
                                                    <div class="flex space-x-1">
                                                        <a href="{{ route('truck-maintenances.edit', [$truck, $maintenance]) }}" class="text-indigo-600 hover:text-indigo-900" title="Edit">
                                                            <i class="fas fa-edit"></i>
                                                        </a>
                                                        <form action="{{ route('truck-maintenances.destroy', [$truck, $maintenance]) }}" method="POST" class="inline" onsubmit="return confirm('Apakah Anda yakin ingin menghapus catatan maintenance ini?')">
                                                            @csrf
                                                            @method('DELETE')
                                                            <button type="submit" class="text-red-600 hover:text-red-900" title="Hapus">
                                                                <i class="fas fa-trash"></i>
                                                            </button>
                                                        </form>
                                                    </div>
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        @else
                            <div class="bg-white p-4 rounded-lg shadow text-center text-gray-500">
                                Belum ada catatan maintenance untuk truk ini.
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>