<x-app-layout>
    <x-slot name="header">
        <div class="flex justify-between items-center">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">
                {{ __('Detail Pengguna') }}
            </h2>
            <div class="flex space-x-2">
                <a href="{{ route('users.edit', $user) }}" class="bg-yellow-500 hover:bg-yellow-700 text-white font-bold py-2 px-4 rounded">
                    <i class="fas fa-edit mr-2"></i>Edit
                </a>
                <a href="{{ route('users.index') }}" class="bg-gray-500 hover:bg-gray-700 text-white font-bold py-2 px-4 rounded">
                    <i class="fas fa-arrow-left mr-2"></i>Kembali
                </a>
            </div>
        </div>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900">
                    <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                        <!-- Foto Profil -->
                        <div class="md:col-span-1">
                            <div class="bg-gray-100 p-4 rounded-lg">
                                <div class="w-full h-64 flex items-center justify-center bg-gray-200 rounded">
                                    <i class="fas fa-user text-6xl text-gray-400"></i>
                                </div>
                                
                                <div class="mt-4 text-center">
                                    <h3 class="text-xl font-semibold">{{ $user->name }}</h3>
                                    <p class="text-gray-600">
                                        @if($user->isAdmin())
                                            <span class="px-2 py-1 rounded text-xs font-semibold mt-2 inline-block bg-red-100 text-red-800">Administrator</span>
                                        @endif
                                    </p>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Informasi Pengguna -->
                        <div class="md:col-span-2">
                            <h3 class="text-lg font-semibold mb-4 pb-2 border-b">Informasi Pengguna</h3>
                            
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                <div>
                                    <p class="text-gray-600 mb-1">Email</p>
                                    <p class="font-medium">{{ $user->email }}</p>
                                </div>
                                
                                <div>
                                    <p class="text-gray-600 mb-1">Tanggal Bergabung</p>
                                    <p class="font-medium">{{ $user->created_at->format('d/m/Y') }}</p>
                                </div>
                                
                                <div>
                                    <p class="text-gray-600 mb-1">Terakhir Diperbarui</p>
                                    <p class="font-medium">{{ $user->updated_at->format('d/m/Y H:i') }}</p>
                                </div>
                                
                                <div>
                                    <p class="text-gray-600 mb-1">Email Terverifikasi</p>
                                    <p class="font-medium">{{ $user->email_verified_at ? $user->email_verified_at->format('d/m/Y H:i') : 'Belum Terverifikasi' }}</p>
                                </div>
                            </div>
                            
                            <h3 class="text-lg font-semibold mt-6 mb-4 pb-2 border-b">Peran & Izin</h3>
                            
                            <div class="mb-4">
                                <p class="text-gray-600 mb-2">Peran:</p>
                                <div class="flex flex-wrap gap-2">
                                    @forelse ($user->roles as $role)
                                        <span class="px-3 py-1 rounded-full text-sm font-semibold bg-indigo-100 text-indigo-800">
                                            {{ $role->name }}
                                        </span>
                                    @empty
                                        <span class="text-gray-500">Tidak ada peran yang ditetapkan</span>
                                    @endforelse
                                </div>
                            </div>
                            
                            <div>
                                <p class="text-gray-600 mb-2">Izin:</p>
                                <div class="flex flex-wrap gap-2">
                                    @php
                                        $permissions = $user->roles->flatMap(function ($role) {
                                            return $role->permissions;
                                        })->unique('id');
                                    @endphp
                                    
                                    @forelse ($permissions as $permission)
                                        <span class="px-3 py-1 rounded-full text-sm font-semibold bg-green-100 text-green-800">
                                            {{ $permission->name }}
                                        </span>
                                    @empty
                                        <span class="text-gray-500">Tidak ada izin yang ditetapkan</span>
                                    @endforelse
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>